/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.runtime.producer.mapper.impl;

import com.google.code.or.common.glossary.Column;
import com.google.code.or.common.glossary.column.BitColumn;
import com.google.code.or.common.glossary.column.BlobColumn;
import com.google.code.or.common.glossary.column.DateColumn;
import com.google.code.or.common.glossary.column.DatetimeColumn;
import com.google.code.or.common.glossary.column.DecimalColumn;
import com.google.code.or.common.glossary.column.DoubleColumn;
import com.google.code.or.common.glossary.column.EnumColumn;
import com.google.code.or.common.glossary.column.FloatColumn;
import com.google.code.or.common.glossary.column.Int24Column;
import com.google.code.or.common.glossary.column.LongColumn;
import com.google.code.or.common.glossary.column.LongLongColumn;
import com.google.code.or.common.glossary.column.NullColumn;
import com.google.code.or.common.glossary.column.SetColumn;
import com.google.code.or.common.glossary.column.ShortColumn;
import com.google.code.or.common.glossary.column.StringColumn;
import com.google.code.or.common.glossary.column.TimeColumn;
import com.google.code.or.common.glossary.column.TimestampColumn;
import com.google.code.or.common.glossary.column.TinyColumn;
import com.google.code.or.common.glossary.column.YearColumn;
import com.linkedin.databus.core.DatabusRuntimeException;
import com.linkedin.databus2.core.DatabusException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class ORToAvroMapper {
    private static final Logger LOGGER = LogFactory.getLogger(ORToAvroMapper.class);

    public Object orToAvroType(Column column) throws DatabusException {
        if (column instanceof BitColumn) {
            BitColumn byteColumn = (BitColumn)column;
            byte[] byteArray = byteColumn.getValue();
            return ByteBuffer.wrap(byteArray);
        }
        if (column instanceof BlobColumn) {
            BlobColumn blobColumn = (BlobColumn)column;
            byte[] byteArray = blobColumn.getValue();
            return ByteBuffer.wrap(byteArray);
        }
        if (column instanceof DateColumn) {
            DateColumn dateColumn = (DateColumn)column;
            Date date = dateColumn.getValue();
            return date.getTime();
        }
        if (column instanceof DatetimeColumn) {
            DatetimeColumn dateTimeColumn = (DatetimeColumn)column;
            java.util.Date date = dateTimeColumn.getValue();
            return date.getTime() / 1000L * 1000L;
        }
        if (column instanceof DecimalColumn) {
            DecimalColumn decimalColumn = (DecimalColumn)column;
            return decimalColumn.getValue().toString();
        }
        if (column instanceof DoubleColumn) {
            DoubleColumn doubleColumn = (DoubleColumn)column;
            return doubleColumn.getValue();
        }
        if (column instanceof EnumColumn) {
            EnumColumn enumColumn = (EnumColumn)column;
            return enumColumn.getValue();
        }
        if (column instanceof FloatColumn) {
            FloatColumn floatColumn = (FloatColumn)column;
            return floatColumn.getValue();
        }
        if (column instanceof Int24Column) {
            Int24Column intColumn = (Int24Column)column;
            return intColumn.getValue();
        }
        if (column instanceof LongColumn) {
            LongColumn longColumn = (LongColumn)column;
            return longColumn.getValue();
        }
        if (column instanceof LongLongColumn) {
            LongLongColumn longLongColumn = (LongLongColumn)column;
            return longLongColumn.getValue();
        }
        if (column instanceof NullColumn) {
            return null;
        }
        if (column instanceof SetColumn) {
            SetColumn setColumn = (SetColumn)column;
            return setColumn.getValue();
        }
        if (column instanceof ShortColumn) {
            ShortColumn shortColumn = (ShortColumn)column;
            return shortColumn.getValue();
        }
        if (column instanceof StringColumn) {
            StringColumn stringColumn = (StringColumn)column;
            return new String(stringColumn.getValue(), Charset.defaultCharset());
        }
        if (column instanceof TimeColumn) {
            TimeColumn timeColumn = (TimeColumn)column;
            Time time = timeColumn.getValue();
            Calendar c = Calendar.getInstance();
            c.set(70, 0, 1, 0, 0, 0);
            long rawVal = c.getTimeInMillis() / 1000L * 1000L;
            long val2 = time.getTime() / 1000L * 1000L;
            return val2 - rawVal;
        }
        if (column instanceof TimestampColumn) {
            TimestampColumn timeStampColumn = (TimestampColumn)column;
            Timestamp timeStamp = timeStampColumn.getValue();
            return timeStamp.getTime();
        }
        if (column instanceof TinyColumn) {
            TinyColumn tinyColumn = (TinyColumn)column;
            return tinyColumn.getValue();
        }
        if (column instanceof YearColumn) {
            YearColumn yearColumn = (YearColumn)column;
            return yearColumn.getValue();
        }
        String message = "Unknown MySQL type in the event" + column.getClass() + " Object = " + column;
        LOGGER.error(message);
        throw new DatabusRuntimeException(message);
    }
}

