/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.runtime.producer.eventprocessor.impl;

import com.flipkart.aesop.runtime.producer.eventlistener.OpenReplicationListener;
import com.flipkart.aesop.runtime.producer.eventprocessor.BinLogEventProcessor;
import com.flipkart.aesop.runtime.producer.txnprocessor.MysqlTransactionManager;
import com.google.code.or.binlog.BinlogEventV4;
import com.google.code.or.binlog.impl.event.TableMapEvent;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class TableMapEventProcessor
implements BinLogEventProcessor {
    private static final Logger LOGGER = LogFactory.getLogger(TableMapEventProcessor.class);

    @Override
    public void process(BinlogEventV4 event, OpenReplicationListener listener) throws Exception {
        MysqlTransactionManager manager = listener.getMysqlTransactionManager();
        if (!manager.isBeginTxnSeen()) {
            LOGGER.warn("Skipping event (" + event + ") as this is before the start of first transaction");
            return;
        }
        TableMapEvent tableMapEvent = (TableMapEvent)event;
        String newTableName = String.valueOf(tableMapEvent.getDatabaseName().toString().toLowerCase()) + "." + tableMapEvent.getTableName().toString().toLowerCase();
        Long newTableId = tableMapEvent.getTableId();
        manager.getMysqlTableIdToTableNameMap().put(newTableId, newTableName);
    }
}

