/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.runtime.producer.eventprocessor.impl;

import com.flipkart.aesop.runtime.producer.eventlistener.OpenReplicationListener;
import com.flipkart.aesop.runtime.producer.eventprocessor.BinLogEventProcessor;
import com.google.code.or.binlog.BinlogEventV4;
import com.google.code.or.binlog.impl.event.DeleteRowsEventV2;
import com.linkedin.databus.core.DbusOpcode;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class DeleteEventV2Processor
implements BinLogEventProcessor {
    private static final Logger LOGGER = LogFactory.getLogger(DeleteEventV2Processor.class);

    @Override
    public void process(BinlogEventV4 event, OpenReplicationListener listener) throws Exception {
        if (!listener.getMysqlTransactionManager().isBeginTxnSeen()) {
            LOGGER.warn("Skipping event (" + event + ") as this is before the start of first transaction");
            return;
        }
        LOGGER.debug("Delete Event Received : " + event);
        DeleteRowsEventV2 deleteRowsEvent = (DeleteRowsEventV2)event;
        listener.getMysqlTransactionManager().performChanges(deleteRowsEvent.getTableId(), deleteRowsEvent.getHeader(), deleteRowsEvent.getRows(), DbusOpcode.DELETE);
        LOGGER.debug("Delete Successful for  " + event.getHeader().getEventLength() + " . Data deleted : " + deleteRowsEvent.getRows());
    }
}

