/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.runtime.producer.eventlistener;

import com.flipkart.aesop.runtime.producer.eventprocessor.BinLogEventProcessor;
import com.flipkart.aesop.runtime.producer.schema.eventprocessor.SchemaChangeEventProcessor;
import com.flipkart.aesop.runtime.producer.txnprocessor.MysqlTransactionManager;
import com.google.code.or.binlog.BinlogEventListener;
import com.google.code.or.binlog.BinlogEventV4;
import java.util.Map;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class OpenReplicationListener
implements BinlogEventListener {
    private static final Logger LOGGER = LogFactory.getLogger(OpenReplicationListener.class);
    private final MysqlTransactionManager mysqlTransactionManager;
    private Map<Integer, BinLogEventProcessor> eventsMap;
    private SchemaChangeEventProcessor schemaChangeEventProcessor;
    private String binLogPrefix;

    public OpenReplicationListener(MysqlTransactionManager mysqlTransactionManager, Map<Integer, BinLogEventProcessor> eventsMap, SchemaChangeEventProcessor schemaChangeEventProcessor, String binLogPrefix) {
        this.mysqlTransactionManager = mysqlTransactionManager;
        this.eventsMap = eventsMap;
        this.binLogPrefix = binLogPrefix;
        this.schemaChangeEventProcessor = schemaChangeEventProcessor;
    }

    public void onEvents(BinlogEventV4 event) {
        if (event == null) {
            LOGGER.error("Received null event");
            return;
        }
        try {
            BinLogEventProcessor processor = this.eventsMap.get(event.getHeader().getEventType());
            if (processor != null) {
                processor.process(event, this);
            } else {
                LOGGER.warn("Received Unsupported Event! " + event);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception occurred while processing event " + e);
        }
    }

    public Map<Integer, BinLogEventProcessor> getEventsMap() {
        return this.eventsMap;
    }

    public void setEventsMap(Map<Integer, BinLogEventProcessor> eventsMap) {
        this.eventsMap = eventsMap;
    }

    public MysqlTransactionManager getMysqlTransactionManager() {
        return this.mysqlTransactionManager;
    }

    public String getBinLogPrefix() {
        return this.binLogPrefix;
    }

    public void setBinLogPrefix(String binLogPrefix) {
        this.binLogPrefix = binLogPrefix;
    }

    public SchemaChangeEventProcessor getSchemaChangeEventProcessor() {
        return this.schemaChangeEventProcessor;
    }

    public void setSchemaChangeEventProcessor(SchemaChangeEventProcessor schemaChangeEventProcessor) {
        this.schemaChangeEventProcessor = schemaChangeEventProcessor;
    }
}

