/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.runtime.producer.mapper.impl;

import com.flipkart.aesop.runtime.producer.mapper.BinLogEventMapper;
import com.flipkart.aesop.runtime.producer.mapper.impl.ORToAvroMapper;
import com.google.code.or.binlog.BinlogEventV4Header;
import com.google.code.or.common.glossary.Column;
import com.google.code.or.common.glossary.Row;
import com.linkedin.databus.core.DbusOpcode;
import com.linkedin.databus2.schemas.utils.SchemaHelper;
import java.util.Comparator;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class DefaultBinLogEventMapper
implements BinLogEventMapper<GenericRecord> {
    protected static final Logger LOGGER = LogFactory.getLogger(DefaultBinLogEventMapper.class);
    private static String orderingMetaField = "dbFieldPosition";
    public ORToAvroMapper orToAvroMapper;

    public DefaultBinLogEventMapper() {
    }

    public DefaultBinLogEventMapper(ORToAvroMapper orToAvroMapper) {
        this.orToAvroMapper = orToAvroMapper;
    }

    @Override
    public String getUniqueName() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public GenericRecord mapBinLogEvent(BinlogEventV4Header header, Row row, DbusOpcode databusCode, Schema schema) {
        GenericData.Record record = new GenericData.Record(schema);
        List columns = row.getColumns();
        try {
            List orderedFields = SchemaHelper.getOrderedFieldsByMetaField((Schema)schema, (String)orderingMetaField, (Comparator)new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    Integer pos1 = Integer.parseInt(o1);
                    Integer pos2 = Integer.parseInt(o2);
                    return pos1.compareTo(pos2);
                }
            });
            int cnt = 0;
            for (Schema.Field field : orderedFields) {
                Column column = (Column)columns.get(cnt);
                record.put(field.name(), column == null ? null : this.orToAvroMapper.orToAvroType(column));
                ++cnt;
            }
            LOGGER.info("Mapped GenricRecord for schema " + schema.getName() + " : " + record.toString());
            return record;
        }
        catch (Exception e) {
            LOGGER.error("Error while mapping to DefaultBinlogEvent . Exception : " + e.getMessage() + " Cause: " + e.getCause());
            return null;
        }
    }

    public ORToAvroMapper getOrToAvroMapper() {
        return this.orToAvroMapper;
    }

    public void setOrToAvroMapper(ORToAvroMapper orToAvroMapper) {
        this.orToAvroMapper = orToAvroMapper;
    }
}

