/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.runtime.bootstrap.consumer;

import com.flipkart.aesop.event.AbstractEvent;
import com.flipkart.aesop.eventconsumer.AbstractEventConsumer;
import com.linkedin.databus.client.pub.ConsumerCallbackResult;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class SourceEventProcessor
implements Runnable {
    public static final Logger LOGGER = LogFactory.getLogger(SourceEventProcessor.class);
    private final AbstractEvent sourceEvent;
    private final AbstractEventConsumer consumer;

    public SourceEventProcessor(AbstractEvent sourceEvent, AbstractEventConsumer consumer) {
        this.sourceEvent = sourceEvent;
        this.consumer = consumer;
    }

    @Override
    public void run() {
        try {
            LOGGER.info("Processing :" + this.sourceEvent.getPrimaryKeyValues() + ":" + this.sourceEvent.getNamespaceName() + "." + this.sourceEvent.getEntityName());
            ConsumerCallbackResult consumerCallbackResult = this.consumer.processSourceEvent(this.sourceEvent);
            LOGGER.info(consumerCallbackResult.toString());
        }
        catch (Exception e) {
            LOGGER.error("Exception occurred while processing event " + e.getMessage(), (Throwable)e);
        }
    }
}

