/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.runtime.spring.web;

import com.flipkart.aesop.runtime.bootstrap.BlockingBootstrapServer;
import com.flipkart.aesop.runtime.bootstrap.producer.registeration.ProducerRegistration;
import com.flipkart.aesop.runtime.impl.registry.ServerContainerRegistry;
import com.flipkart.aesop.runtime.spi.admin.RuntimeConfigService;
import com.flipkart.aesop.runtime.spring.web.BlockingBootstrapInfo;
import com.linkedin.databus2.core.container.netty.ServerContainer;
import com.linkedin.databus2.relay.config.LogicalSourceConfig;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class BlockingBootstrapProducerController {
    private static final int MAX_CONNECTIONS = 5;
    private static Logger logger = LoggerFactory.getLogger(BlockingBootstrapProducerController.class);
    private ServerContainerRegistry runtimeRegistry;
    private RuntimeConfigService configService;
    private ObjectMapper mapper = new ObjectMapper();
    private static AtomicInteger concurrentConnections = new AtomicInteger(0);

    @RequestMapping(value={"/relays", "/"}, method={RequestMethod.GET})
    public String relays(ModelMap model, HttpServletRequest request) {
        LinkedList<BlockingBootstrapInfo> blockingBootstrapInfos = new LinkedList<BlockingBootstrapInfo>();
        for (ServerContainer serverContainer : this.runtimeRegistry.getRuntimes()) {
            if (!BlockingBootstrapServer.class.isAssignableFrom(serverContainer.getClass())) continue;
            BlockingBootstrapServer blockingBootstrapServer = (BlockingBootstrapServer)serverContainer;
            for (ProducerRegistration producerRegistration : blockingBootstrapServer.getProducerRegistrationList()) {
                BlockingBootstrapInfo blockingBootstrapInfo = new BlockingBootstrapInfo(producerRegistration.getPhysicalSourceConfig().getId(), producerRegistration.getPhysicalSourceConfig().getName(), producerRegistration.getPhysicalSourceConfig().getUri());
                BlockingBootstrapInfo.LSourceInfo[] lSourceInfos = this.getLogicalSourceForProducer(producerRegistration.getPhysicalSourceConfig().getSources());
                blockingBootstrapInfo.setlSourceInfos(lSourceInfos);
                blockingBootstrapInfo.setProducerName(producerRegistration.getEventProducer().getName());
                blockingBootstrapInfo.setProducerSinceSCN(String.valueOf(producerRegistration.getEventProducer().getSCN()));
                blockingBootstrapInfos.add(blockingBootstrapInfo);
            }
        }
        model.addAttribute("relayInfos", (Object)blockingBootstrapInfos.toArray(new BlockingBootstrapInfo[0]));
        if (request.getServletPath().endsWith(".json")) {
            return "relays-json";
        }
        return "relays";
    }

    @RequestMapping(value={"/metrics"}, method={RequestMethod.GET})
    public String metrics() {
        return "metrics";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/metrics-stream"}, method={RequestMethod.GET})
    @ResponseBody
    public void metricsStream(HttpServletRequest request, HttpServletResponse response) {
        try {
            if (concurrentConnections.incrementAndGet() > 5) {
                logger.info("Client refused due to max concurrency reached");
                response.sendError(503, "Max concurrent connections reached: 5");
            } else {
                BlockingBootstrapServer blockingBootstrapServer = null;
                for (ServerContainer serverContainer : this.runtimeRegistry.getRuntimes()) {
                    if (!BlockingBootstrapServer.class.isAssignableFrom(serverContainer.getClass())) continue;
                    blockingBootstrapServer = (BlockingBootstrapServer)serverContainer;
                    break;
                }
                if (blockingBootstrapServer != null) {
                    logger.info("Client connected: " + request.getSession().getId());
                    response.setHeader("Content-Type", "text/event-stream;charset=UTF-8");
                    response.setHeader("Cache-Control", "no-cache, no-store, max-age=0, must-revalidate");
                    response.setHeader("Pragma", "no-cache");
                    while (true) {
                        response.getWriter().println("data: " + blockingBootstrapServer.getMetricsCollector().getJson() + "\n");
                        response.flushBuffer();
                        Thread.sleep(blockingBootstrapServer.getMetricsCollector().getRefreshInterval() * 1000);
                    }
                }
                logger.info("Relay not found!");
                response.sendError(404, "Relay not found!");
            }
        }
        catch (IOException e) {
            logger.info("Client Disconnected: " + request.getSession().getId());
        }
        catch (InterruptedException e) {
            logger.info("Client Disconnected: " + request.getSession().getId() + " (Interrupted)");
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            logger.error("Client Disconnected: " + request.getSession().getId() + " (Unknown Exception)", (Throwable)e);
        }
        finally {
            concurrentConnections.decrementAndGet();
        }
    }

    @RequestMapping(value={"/metrics-json"}, method={RequestMethod.GET})
    @ResponseBody
    public void metricsJSON(HttpServletRequest request, HttpServletResponse response) {
        try {
            response.setHeader("Content-Type", "application/json");
            response.setHeader("Cache-Control", "no-cache, no-store, max-age=0, must-revalidate");
            response.setHeader("Pragma", "no-cache");
            BlockingBootstrapServer blockingBootstrapServer = null;
            for (ServerContainer serverContainer : this.runtimeRegistry.getRuntimes()) {
                if (!BlockingBootstrapServer.class.isAssignableFrom(serverContainer.getClass())) continue;
                blockingBootstrapServer = (BlockingBootstrapServer)serverContainer;
                break;
            }
            if (blockingBootstrapServer != null) {
                if (request.getParameterMap().containsKey("full")) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("inbound", blockingBootstrapServer.getInboundEventStatisticsCollector());
                    map.put("outbound", blockingBootstrapServer.getOutboundEventStatisticsCollector());
                    map.put("http", blockingBootstrapServer.getHttpStatisticsCollector());
                    response.getWriter().print(this.mapper.writeValueAsString(map));
                } else {
                    response.getWriter().print(blockingBootstrapServer.getMetricsCollector().getJson());
                }
            } else {
                response.getWriter().println("{}");
            }
            response.flushBuffer();
        }
        catch (IOException e) {
            logger.info("Client Disconnected: " + request.getSession().getId());
        }
        catch (Exception e) {
            logger.error("Client Disconnected: " + request.getSession().getId() + " (Unknown Exception)", (Throwable)e);
        }
    }

    public ServerContainerRegistry getRuntimeRegistry() {
        return this.runtimeRegistry;
    }

    public void setRuntimeRegistry(ServerContainerRegistry runtimeRegistry) {
        this.runtimeRegistry = runtimeRegistry;
    }

    public RuntimeConfigService getConfigService() {
        return this.configService;
    }

    public void setConfigService(RuntimeConfigService configService) {
        this.configService = configService;
    }

    private BlockingBootstrapInfo.LSourceInfo[] getLogicalSourceForProducer(List<LogicalSourceConfig> lSources) {
        BlockingBootstrapInfo.LSourceInfo[] lSourceInfos = new BlockingBootstrapInfo.LSourceInfo[lSources.size()];
        for (int i = 0; i < lSourceInfos.length; ++i) {
            lSourceInfos[i] = new BlockingBootstrapInfo.LSourceInfo(lSources.get(i).getId());
            lSourceInfos[i].setLSourceName(lSources.get(i).getName());
            lSourceInfos[i].setLSourceURI(lSources.get(i).getUri());
        }
        return lSourceInfos;
    }
}

