/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.runtime.bootstrap;

import com.flipkart.aesop.runtime.bootstrap.BlockingBootstrapServer;
import com.flipkart.aesop.runtime.bootstrap.configs.BootstrapConfig;
import com.flipkart.aesop.runtime.bootstrap.consumer.SourceEventConsumer;
import com.flipkart.aesop.runtime.bootstrap.producer.BlockingEventProducer;
import com.flipkart.aesop.runtime.bootstrap.producer.registeration.ProducerRegistration;
import com.linkedin.databus.container.netty.HttpRelay;
import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.ConfigLoader;
import com.linkedin.databus2.producers.EventProducer;
import com.linkedin.databus2.relay.config.LogicalSourceConfig;
import com.linkedin.databus2.relay.config.PhysicalSourceStaticConfig;
import com.linkedin.databus2.schemas.FileSystemSchemaRegistryService;
import com.linkedin.databus2.schemas.SchemaRegistryService;
import com.linkedin.databus2.schemas.SourceIdNameRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.FactoryBean;

public class BlockingBootstrapServerFactory
implements FactoryBean<BlockingBootstrapServer> {
    private BootstrapConfig bootstrapConfig;
    private SourceEventConsumer consumer;
    private List<ProducerRegistration> producerRegistrationList = new ArrayList<ProducerRegistration>();

    public BlockingBootstrapServer getObject() throws Exception {
        HttpRelay.Config httpConfig = new HttpRelay.Config();
        ConfigLoader staticConfigLoader = new ConfigLoader("databus.bootstrap.", (ConfigBuilder)httpConfig);
        HttpRelay.StaticConfig[] staticConfigList = new HttpRelay.StaticConfig[this.producerRegistrationList.size()];
        PhysicalSourceStaticConfig[] pStaticConfigs = new PhysicalSourceStaticConfig[this.producerRegistrationList.size()];
        FileSystemSchemaRegistryService.Config configBuilder = new FileSystemSchemaRegistryService.Config();
        configBuilder.setFallbackToResources(true);
        configBuilder.setSchemaDir(this.bootstrapConfig.getSchemaRegistryLocation());
        FileSystemSchemaRegistryService.StaticConfig schemaRegistryServiceConfig = configBuilder.build();
        FileSystemSchemaRegistryService schemaRegistryService = FileSystemSchemaRegistryService.build((FileSystemSchemaRegistryService.StaticConfig)schemaRegistryServiceConfig);
        int i = 0;
        while (i < this.producerRegistrationList.size()) {
            Properties mergedProperties = new Properties();
            mergedProperties.putAll((Map<?, ?>)this.bootstrapConfig.getBootstrapProperties());
            if (this.producerRegistrationList.get(i).getProperties() != null) {
                mergedProperties.putAll((Map<?, ?>)this.producerRegistrationList.get(i).getProperties());
            }
            staticConfigList[i] = (HttpRelay.StaticConfig)staticConfigLoader.loadConfig((Map)mergedProperties);
            pStaticConfigs[i] = this.producerRegistrationList.get(i).getPhysicalSourceConfig().build();
            ++i;
        }
        BlockingBootstrapServer bootstrapServer = new BlockingBootstrapServer(staticConfigList[0], pStaticConfigs, SourceIdNameRegistry.createFromIdNamePairs((Collection)staticConfigList[0].getSourceIds()), (SchemaRegistryService)schemaRegistryService);
        boolean i2 = false;
        for (ProducerRegistration producerRegistration : this.producerRegistrationList) {
            EventProducer producer = producerRegistration.getEventProducer();
            if (!BlockingEventProducer.class.isAssignableFrom(producer.getClass())) continue;
            BlockingEventProducer blockingEventProducer = (BlockingEventProducer)producer;
            blockingEventProducer.registerConsumer(this.consumer);
            blockingEventProducer.setPhysicalSourceConfig(producerRegistration.getPhysicalSourceConfig());
            blockingEventProducer.setSchemaRegistryService((SchemaRegistryService)schemaRegistryService);
            for (LogicalSourceConfig logicalSourceConfig : producerRegistration.getPhysicalSourceConfig().getSources()) {
                httpConfig.setSourceName(String.valueOf(logicalSourceConfig.getId()), logicalSourceConfig.getName());
            }
            blockingEventProducer.setDbusEventsStatisticsCollector(bootstrapServer.getInboundEventStatisticsCollector());
            blockingEventProducer.registerMetricsCollector(bootstrapServer.getMetricsCollector());
        }
        bootstrapServer.registerConsumer(this.consumer);
        bootstrapServer.setProducerRegistrationList(this.producerRegistrationList);
        return bootstrapServer;
    }

    public Class<?> getObjectType() {
        return BlockingBootstrapServer.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBootstrapConfig(BootstrapConfig bootstrapConfig) {
        this.bootstrapConfig = bootstrapConfig;
    }

    public void setConsumer(SourceEventConsumer consumer) {
        this.consumer = consumer;
    }

    public void setProducerRegistrationList(List<ProducerRegistration> producerRegistrationList) {
        this.producerRegistrationList = producerRegistrationList;
    }

    public List<ProducerRegistration> getProducerRegistrationList() {
        return this.producerRegistrationList;
    }
}

