/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.runtime.config;

import java.io.File;
import java.util.Properties;
import org.springframework.util.Assert;
import org.trpr.platform.core.PlatformException;
import org.trpr.platform.runtime.common.RuntimeVariables;

public class BootstrapConfig {
    public static final String BOOTSTRAP_PROPERTIES_PREFIX = "databus.bootstrap.";
    public static final String CHECKPOINT_DIR_PROPERTY = "db.client.checkpointPersistence.fileSystem.rootDirectory";
    private Properties bootstrapProperties = new Properties();
    private String checkpointDirectoryLocation;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.checkpointDirectoryLocation, (String)"'checkpointDirectoryLocation' cannot be null. This Bootstrap Server will not be initialized");
        for (Object key : this.bootstrapProperties.keySet()) {
            if (((String)key).startsWith(BOOTSTRAP_PROPERTIES_PREFIX)) continue;
            throw new PlatformException("Property : " + key + " does not begin with the prefix : " + BOOTSTRAP_PROPERTIES_PREFIX);
        }
    }

    public Properties getBootstrapProperties() {
        return this.bootstrapProperties;
    }

    public void setBootstrapProperties(Properties bootstrapProperties) {
        this.bootstrapProperties = bootstrapProperties;
    }

    public String getCheckpointDirectoryLocation() {
        return this.checkpointDirectoryLocation;
    }

    public void setCheckpointDirectoryLocation(String checkpointDirectoryLocation) {
        this.checkpointDirectoryLocation = checkpointDirectoryLocation;
        this.getBootstrapProperties().put("databus.bootstrap.db.client.checkpointPersistence.fileSystem.rootDirectory", new File(RuntimeVariables.getProjectsRoot() + File.separator + this.checkpointDirectoryLocation).getAbsolutePath());
    }
}

