/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.runtime.config;

import com.flipkart.aesop.runtime.config.ClientConfig;
import com.flipkart.aesop.runtime.config.ClusterInfoConfig;
import java.util.List;
import org.springframework.util.Assert;

public class ClientClusterConfig
extends ClientConfig {
    public static final String CLIENT_CLUSTER_NAMESPACE = "databus.client.clientCluster";
    public static final String CLUSTERNAME = "clusterName";
    public static final String ZKADDR = "zkAddr";
    public static final String NUMPARTITIONS = "numPartitions";
    public static final String QUORUM = "quorum";
    public static final String ZKSESSIONTIMEOUTMS = "zkSessionTimeoutMs";
    public static final String ZKCONNECTIONTIMEOUTMS = "zkConnectionTimeoutMs";
    public static final String CHECKPOINTINTERVALMS = "checkpointIntervalMs";
    private List<ClusterInfoConfig> clusterInfoConfigs;

    public List<ClusterInfoConfig> getClusterInfoConfigs() {
        return this.clusterInfoConfigs;
    }

    public void setClusterInfoConfigs(List<ClusterInfoConfig> clusterInfoConfigs) {
        this.clusterInfoConfigs = clusterInfoConfigs;
        for (ClusterInfoConfig clusterInfoConfig : this.clusterInfoConfigs) {
            this.getClientProperties().put(this.getClusterClientPropertyName(clusterInfoConfig.getId()) + CLUSTERNAME, clusterInfoConfig.getClusterName());
            this.getClientProperties().put(this.getClusterClientPropertyName(clusterInfoConfig.getId()) + ZKADDR, clusterInfoConfig.getZkAddr());
            this.getClientProperties().put(this.getClusterClientPropertyName(clusterInfoConfig.getId()) + NUMPARTITIONS, clusterInfoConfig.getNumPartitions());
            this.getClientProperties().put(this.getClusterClientPropertyName(clusterInfoConfig.getId()) + QUORUM, clusterInfoConfig.getQuorum());
            this.getClientProperties().put(this.getClusterClientPropertyName(clusterInfoConfig.getId()) + ZKSESSIONTIMEOUTMS, clusterInfoConfig.getZkSessionTimeoutMs());
            this.getClientProperties().put(this.getClusterClientPropertyName(clusterInfoConfig.getId()) + ZKCONNECTIONTIMEOUTMS, clusterInfoConfig.getZkConnectionTimeoutMs());
            this.getClientProperties().put(this.getClusterClientPropertyName(clusterInfoConfig.getId()) + CHECKPOINTINTERVALMS, clusterInfoConfig.getCheckpointIntervalMs());
        }
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull(this.clusterInfoConfigs, (String)"'clusterInfoConfigs' cannot be null. This Databus Client Cluster will not be initialized");
    }

    public String getClusterClientPropertyName(int id) {
        return "databus.client.clientCluster(" + id + ").";
    }
}

