/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.runtime.clusterclient;

import com.flipkart.aesop.runtime.client.DefaultClient;
import com.flipkart.aesop.runtime.config.ClientClusterConfig;
import com.flipkart.aesop.runtime.config.ClusterRegistration;
import com.linkedin.databus.client.DatabusHttpClientImpl;
import com.linkedin.databus.client.pub.DatabusRegistration;
import com.linkedin.databus.client.pub.DbusClusterConsumerFactory;
import com.linkedin.databus.client.pub.DbusModPartitionedFilterFactory;
import com.linkedin.databus.client.pub.DbusPartitionListener;
import com.linkedin.databus.client.pub.DbusServerSideFilterFactory;
import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.ConfigLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class DefaultClusterClientFactory
implements FactoryBean<DefaultClient>,
InitializingBean {
    private ClientClusterConfig clientClusterConfig;
    private List<ClusterRegistration> clusterRegistrations;
    private List<DatabusRegistration> databusRegistrations = new ArrayList<DatabusRegistration>();
    private DefaultClient databusClient;
    private static final Logger logger = LogFactory.getLogger(DefaultClusterClientFactory.class);

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)((Object)this.clientClusterConfig), (String)"'clientClusterConfig' cannot be null. This Relay Cluster Client will not be initialized");
        Assert.notEmpty(this.clusterRegistrations, (String)"'clusterRegistrations' cannot be empty. No Cluster Registrations.");
    }

    public DefaultClient getObject() throws Exception {
        DatabusHttpClientImpl.Config config = new DatabusHttpClientImpl.Config();
        ConfigLoader staticConfigLoader = new ConfigLoader(this.clientClusterConfig.getClientPropertiesPrefix(), (ConfigBuilder)config);
        Properties properties = this.clientClusterConfig.getClientProperties();
        DatabusHttpClientImpl.StaticConfig staticConfig = (DatabusHttpClientImpl.StaticConfig)staticConfigLoader.loadConfig((Map)properties);
        this.databusClient = new DefaultClient(staticConfig);
        for (ClusterRegistration clusterRegistration : this.clusterRegistrations) {
            String clusterName = clusterRegistration.getClusterName();
            DbusPartitionListener partitionListener = clusterRegistration.getPartitionListener();
            DbusClusterConsumerFactory consumerFactory = clusterRegistration.getConsumerFactory();
            List<String> logicalSources = clusterRegistration.getLogicalSources();
            String[] logicalSourcesArr = logicalSources.toArray(new String[0]);
            DbusServerSideFilterFactory filterFactory = clusterRegistration.getFilterFactory();
            if (filterFactory == null) {
                filterFactory = new DbusModPartitionedFilterFactory(logicalSourcesArr);
            }
            DatabusRegistration registration = this.databusClient.registerCluster(clusterName, consumerFactory, filterFactory, partitionListener, logicalSourcesArr);
            this.databusRegistrations.add(registration);
        }
        for (DatabusRegistration databusRegistration : this.databusRegistrations) {
            databusRegistration.start();
        }
        logger.info("Adding shutdown hook");
        Runtime.getRuntime().addShutdownHook(new ClusterShutDownHookThread());
        logger.info("Added shutdown hook");
        return this.databusClient;
    }

    public Class<?> getObjectType() {
        return DefaultClient.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public ClientClusterConfig getClientClusterConfig() {
        return this.clientClusterConfig;
    }

    public void setClientClusterConfig(ClientClusterConfig clientClusterConfig) {
        this.clientClusterConfig = clientClusterConfig;
    }

    public List<ClusterRegistration> getClusterRegistrations() {
        return this.clusterRegistrations;
    }

    public void setClusterRegistrations(List<ClusterRegistration> clusterRegistrations) {
        this.clusterRegistrations = clusterRegistrations;
    }

    private class ClusterShutDownHookThread
    extends Thread {
        private ClusterShutDownHookThread() {
        }

        @Override
        public void run() {
            logger.info("ClusterShutDownHookThread getting executed. Shutting down Client");
            DefaultClusterClientFactory.this.databusClient.shutdown();
            logger.info("ClusterShutDownHookThread executed. Client shutdown complete");
        }
    }
}

