/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.runtime.config;

import com.flipkart.aesop.runtime.config.BootstrapClientConfig;
import com.flipkart.aesop.runtime.config.RelayClientConfig;
import java.io.File;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.trpr.platform.core.PlatformException;
import org.trpr.platform.runtime.common.RuntimeVariables;

public class ClientConfig
implements InitializingBean {
    protected static final String CLIENT_PROPERTIES_PREFIX = "databus.client.";
    private static final String RELAY = "runtime.relay";
    private static final String RELAY_HOST = ".host";
    private static final String RELAY_PORT = ".port";
    private static final String RELAY_LOGICAL_SOURCES = ".sources";
    private static final String BOOTSTRAP = "runtime.bootstrap.service";
    private static final String BOOTSTRAP_HOST = ".host";
    private static final String BOOTSTRAP_PORT = ".port";
    private static final String BOOTSTRAP_LOGICAL_SOURCES = ".sources";
    private static final String BOOTSTRAP_ENABLED = "runtime.bootstrap.enabled";
    public static final String CHECKPOINT_DIR_PROPERTY = "checkpointPersistence.fileSystem.rootDirectory";
    private String clientPropertiesPrefix = "databus.client.";
    private Properties clientProperties = new Properties();
    private String checkpointDirectoryLocation;
    private List<RelayClientConfig> relayClientConfigs;
    private List<BootstrapClientConfig> bootstrapClientConfigs;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.relayClientConfigs, (String)"'relayClientConfig' cannot be null. This Databus Client will not be initialized");
        Assert.notNull((Object)this.checkpointDirectoryLocation, (String)"'checkpointDirectoryLocation' cannot be null. This Databus Client will not be initialized");
        for (Object key : this.clientProperties.keySet()) {
            if (((String)key).startsWith(this.getClientPropertiesPrefix())) continue;
            throw new PlatformException("Property : " + key + " does not begin with the prefix : " + this.getClientPropertiesPrefix());
        }
    }

    public String getClientPropertiesPrefix() {
        return this.clientPropertiesPrefix;
    }

    public void setClientPropertiesPrefix(String clientPropertiesPrefix) {
        this.clientPropertiesPrefix = clientPropertiesPrefix;
    }

    public Properties getClientProperties() {
        return this.clientProperties;
    }

    public void setClientProperties(Properties clientProperties) {
        this.clientProperties = clientProperties;
    }

    public String getCheckpointDirectoryLocation() {
        return this.checkpointDirectoryLocation;
    }

    public void setCheckpointDirectoryLocation(String checkpointDirectoryLocation) {
        this.checkpointDirectoryLocation = checkpointDirectoryLocation;
        this.getClientProperties().put(this.getClientPropertiesPrefix() + CHECKPOINT_DIR_PROPERTY, new File(RuntimeVariables.getProjectsRoot() + File.separator + this.checkpointDirectoryLocation).getAbsolutePath());
    }

    public List<RelayClientConfig> getRelayClientConfig() {
        return this.relayClientConfigs;
    }

    public void setRelayClientConfigs(List<RelayClientConfig> relayClientConfigs) {
        this.relayClientConfigs = relayClientConfigs;
        for (RelayClientConfig relayClientConfig : this.relayClientConfigs) {
            this.getClientProperties().put(this.getClientPropertiesPrefix() + this.getRelayProperty(relayClientConfig) + ".host", relayClientConfig.getRelayHost());
            this.getClientProperties().put(this.getClientPropertiesPrefix() + this.getRelayProperty(relayClientConfig) + ".port", relayClientConfig.getRelayPort());
            String commaSeparedLogicalSources = StringUtils.join(relayClientConfig.getRelayLogicalSourceNames(), (String)",");
            this.getClientProperties().put(this.getClientPropertiesPrefix() + this.getRelayProperty(relayClientConfig) + ".sources", commaSeparedLogicalSources);
        }
    }

    public List<BootstrapClientConfig> getBootstrapClientConfig() {
        return this.bootstrapClientConfigs;
    }

    public void setBootstrapClientConfig(List<BootstrapClientConfig> bootstrapClientConfigs) {
        this.bootstrapClientConfigs = bootstrapClientConfigs;
        for (BootstrapClientConfig bootstrapClientConfig : bootstrapClientConfigs) {
            this.getClientProperties().put(this.getClientPropertiesPrefix() + this.getBootstrapProperty(bootstrapClientConfig) + ".host", bootstrapClientConfig.getBootstrapHost());
            this.getClientProperties().put(this.getClientPropertiesPrefix() + this.getBootstrapProperty(bootstrapClientConfig) + ".port", bootstrapClientConfig.getBootstrapPort());
            String commaSeparedLogicalSources = StringUtils.join(bootstrapClientConfig.getBootstrapLogicalSourceNames(), (String)",");
            this.getClientProperties().put(this.getClientPropertiesPrefix() + this.getBootstrapProperty(bootstrapClientConfig) + ".sources", commaSeparedLogicalSources);
            this.getClientProperties().put(this.getClientPropertiesPrefix() + BOOTSTRAP_ENABLED, (Object)true);
        }
    }

    private String getRelayProperty(RelayClientConfig relayClientConfig) {
        return "runtime.relay(" + relayClientConfig.getRelayId() + ")";
    }

    private String getBootstrapProperty(BootstrapClientConfig bootstrapClientConfig) {
        return "runtime.bootstrap.service(" + bootstrapClientConfig.getBootstrapId() + ")";
    }
}

