/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.runtime.relay;

import com.flipkart.aesop.runtime.config.ProducerRegistration;
import com.flipkart.aesop.runtime.metrics.MetricsCollector;
import com.flipkart.aesop.runtime.producer.AbstractEventProducer;
import com.flipkart.aesop.runtime.relay.netty.HttpRelayPipelineFactory;
import com.linkedin.databus.container.netty.HttpRelay;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.core.seq.MultiServerSequenceNumberHandler;
import com.linkedin.databus2.producers.EventProducer;
import com.linkedin.databus2.relay.config.PhysicalSourceStaticConfig;
import com.linkedin.databus2.schemas.SchemaRegistryService;
import com.linkedin.databus2.schemas.SourceIdNameRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class DefaultRelay
extends HttpRelay {
    protected static final Logger LOGGER = LogFactory.getLogger(DefaultRelay.class);
    protected MultiServerSequenceNumberHandler maxScnReaderWriters;
    protected List<ProducerRegistration> producerRegistrationList = new ArrayList<ProducerRegistration>();
    private MetricsCollector metricsCollector = new MetricsCollector(this);

    public DefaultRelay(HttpRelay.StaticConfig config, PhysicalSourceStaticConfig[] pConfigs, SourceIdNameRegistry sourcesIdNameRegistry, SchemaRegistryService schemaRegistry) throws IOException, InvalidConfigException, DatabusException {
        super(config, pConfigs, sourcesIdNameRegistry, schemaRegistry);
    }

    public void pause() {
        super.pause();
        for (ProducerRegistration producerRegistration : this.producerRegistrationList) {
            producerRegistration.getEventProducer().pause();
        }
    }

    public void resume() {
        super.resume();
        for (ProducerRegistration producerRegistration : this.producerRegistrationList) {
            producerRegistration.getEventProducer().unpause();
        }
    }

    public void suspendOnError(Throwable cause) {
        super.suspendOnError(cause);
        for (ProducerRegistration producerRegistration : this.producerRegistrationList) {
            producerRegistration.getEventProducer().shutdown();
        }
    }

    protected void initializeRelayNetworking() throws IOException, DatabusException {
        this._httpBootstrap.setPipelineFactory((ChannelPipelineFactory)new HttpRelayPipelineFactory(this, this._httpBootstrap.getPipelineFactory()));
    }

    protected void doStart() {
        super.doStart();
        for (ProducerRegistration producerRegistration : this.producerRegistrationList) {
            EventProducer producer = producerRegistration.getEventProducer();
            long startScn = -1L;
            if (AbstractEventProducer.class.isAssignableFrom(producer.getClass())) {
                try {
                    startScn = ((AbstractEventProducer)producer).getMaxScnReaderWriter().getMaxScn();
                }
                catch (Exception e) {
                    LOGGER.error("Error starting producer : '" + ((AbstractEventProducer)producer).getName() + "'. Producer not started.", (Throwable)e);
                    continue;
                }
            }
            producer.start(startScn);
        }
        this.registerShutdownHook();
    }

    protected void doShutdown() {
        LOGGER.info("Shutting down Relay");
        for (ProducerRegistration producerRegistration : this.producerRegistrationList) {
            producerRegistration.getEventProducer().shutdown();
        }
        LOGGER.info("All producers shutdown completed");
        super.doShutdown();
        LOGGER.info("Relay shutdown completed");
    }

    public MultiServerSequenceNumberHandler getMaxScnReaderWriters() {
        return this.maxScnReaderWriters;
    }

    public void setMaxScnReaderWriters(MultiServerSequenceNumberHandler maxScnReaderWriters) {
        this.maxScnReaderWriters = maxScnReaderWriters;
    }

    public void setProducerRegistrationList(List<ProducerRegistration> producerRegistrationList) {
        this.producerRegistrationList = producerRegistrationList;
    }

    public List<ProducerRegistration> getProducerRegistrationList() {
        return this.producerRegistrationList;
    }

    public MetricsCollector getMetricsCollector() {
        return this.metricsCollector;
    }
}

