/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.runtime.metrics;

import com.linkedin.databus.core.monitoring.mbean.DbusEventsTotalStats;
import com.linkedin.databus2.core.container.monitoring.mbean.DbusHttpTotalStats;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.codehaus.jackson.map.ObjectMapper;

public class MetricsCollector {
    private static final int DEFAULT_REFRESH_INTERVAL = 3;
    private static final int DEFAULT_MAX_SIZE = 60;
    private ScheduledExecutorService scheduledExecutorService;
    private ObjectMapper objectMapper = new ObjectMapper();
    private String json = "";
    private int refreshInterval = 3;
    private DbusHttpTotalStats httpTotalStats;
    private DbusEventsTotalStats inboundTotalStats;
    private DbusEventsTotalStats outboundTotalStats;

    public MetricsCollector(DbusHttpTotalStats httpTotalStats, DbusEventsTotalStats inboundStats, DbusEventsTotalStats outboundStats) {
        this.httpTotalStats = httpTotalStats;
        this.inboundTotalStats = inboundStats;
        this.outboundTotalStats = outboundStats;
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        this.scheduledExecutorService.scheduleAtFixedRate(new Encoder(this), 0L, 3L, TimeUnit.SECONDS);
    }

    public String getJson() {
        return this.json;
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public class Encoder
    implements Runnable {
        private MetricsCollector collector;

        public Encoder(MetricsCollector collector) {
            this.collector = collector;
        }

        @Override
        public void run() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("http", this.collector.httpTotalStats);
            map.put("inbound", this.collector.inboundTotalStats);
            map.put("outbound", this.collector.outboundTotalStats);
            try {
                this.collector.json = this.collector.objectMapper.writeValueAsString(map);
            }
            catch (Exception e) {
                this.collector.json = this.mapException(e);
            }
        }

        private String mapException(Exception e) {
            try {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("status", "exception");
                map.put("class", e.getClass().getName());
                map.put("message", e.getMessage());
                return MetricsCollector.this.objectMapper.writeValueAsString(map);
            }
            catch (Exception x) {
                return "";
            }
        }
    }
}

