/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.runtime.producer;

import com.linkedin.databus.core.DbusEventBufferAppendable;
import com.linkedin.databus.core.monitoring.mbean.DbusEventsStatisticsCollector;
import com.linkedin.databus2.core.seq.MaxSCNReaderWriter;
import com.linkedin.databus2.producers.EventProducer;
import com.linkedin.databus2.relay.config.PhysicalSourceConfig;
import com.linkedin.databus2.relay.config.PhysicalSourceStaticConfig;
import com.linkedin.databus2.schemas.SchemaRegistryService;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public abstract class AbstractEventProducer
implements EventProducer {
    private static final Logger LOGGER = LogFactory.getLogger(AbstractEventProducer.class);
    protected String name;
    protected PhysicalSourceConfig physicalSourceConfig;
    protected PhysicalSourceStaticConfig physicalSourceStaticConfig;
    protected SchemaRegistryService schemaRegistryService;
    protected AtomicLong sinceSCN = new AtomicLong(-1L);
    protected DbusEventBufferAppendable eventBuffer;
    protected MaxSCNReaderWriter maxScnReaderWriter;
    protected DbusEventsStatisticsCollector dbusEventsStatisticsCollector;
    protected EncoderFactory factory = EncoderFactory.get();
    protected BinaryEncoder cachedAvroEncoder;

    protected byte[] serializeEvent(GenericRecord record) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            BinaryEncoder encoder = this.factory.directBinaryEncoder((OutputStream)bos, this.cachedAvroEncoder);
            GenericDatumWriter writer = new GenericDatumWriter(record.getSchema());
            writer.write((Object)record, (Encoder)encoder);
            byte[] serializedValue = bos.toByteArray();
            return serializedValue;
        }
        catch (Exception ex) {
            LOGGER.error("Error serializing Avro object : " + record.getSchema(), (Throwable)ex);
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public long getSCN() {
        return this.sinceSCN.get();
    }

    public void setSchemaRegistryService(SchemaRegistryService schemaRegistryService) throws Exception {
        this.schemaRegistryService = schemaRegistryService;
        this.physicalSourceStaticConfig = this.physicalSourceConfig.build();
    }

    public void setDbusEventsStatisticsCollector(DbusEventsStatisticsCollector dbusEventsStatisticsCollector) {
        this.dbusEventsStatisticsCollector = dbusEventsStatisticsCollector;
    }

    public PhysicalSourceConfig getPhysicalSourceConfig() {
        return this.physicalSourceConfig;
    }

    public void setPhysicalSourceConfig(PhysicalSourceConfig physicalSourceConfig) {
        this.physicalSourceConfig = physicalSourceConfig;
        this.name = this.physicalSourceConfig.getName();
    }

    public AtomicLong getSinceSCN() {
        return this.sinceSCN;
    }

    public void setSinceSCN(AtomicLong sinceSCN) {
        this.sinceSCN = sinceSCN;
    }

    public DbusEventBufferAppendable getEventBuffer() {
        return this.eventBuffer;
    }

    public void setEventBuffer(DbusEventBufferAppendable eventBuffer) {
        this.eventBuffer = eventBuffer;
    }

    public MaxSCNReaderWriter getMaxScnReaderWriter() {
        return this.maxScnReaderWriter;
    }

    public void setMaxScnReaderWriter(MaxSCNReaderWriter maxScnReaderWriter) {
        this.maxScnReaderWriter = maxScnReaderWriter;
    }

    public PhysicalSourceStaticConfig getPhysicalSourceStaticConfig() {
        return this.physicalSourceStaticConfig;
    }

    public void shutdown() {
        this.eventBuffer.rollbackEvents();
    }
}

