/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.runtime.relay;

import com.flipkart.aesop.runtime.config.ProducerRegistration;
import com.flipkart.aesop.runtime.config.RelayConfig;
import com.flipkart.aesop.runtime.producer.AbstractEventProducer;
import com.flipkart.aesop.runtime.producer.ProducerEventBuffer;
import com.flipkart.aesop.runtime.relay.DefaultRelay;
import com.linkedin.databus.container.netty.HttpRelay;
import com.linkedin.databus.core.DbusEventBufferAppendable;
import com.linkedin.databus.core.NamedObject;
import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.ConfigLoader;
import com.linkedin.databus2.core.seq.MultiServerSequenceNumberHandler;
import com.linkedin.databus2.core.seq.SequenceNumberHandlerFactory;
import com.linkedin.databus2.producers.RelayEventProducersRegistry;
import com.linkedin.databus2.relay.config.LogicalSourceConfig;
import com.linkedin.databus2.relay.config.PhysicalSourceStaticConfig;
import com.linkedin.databus2.schemas.FileSystemSchemaRegistryService;
import com.linkedin.databus2.schemas.SchemaRegistryService;
import com.linkedin.databus2.schemas.SourceIdNameRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class DefaultRelayFactory
implements FactoryBean<DefaultRelay>,
InitializingBean {
    public static final String STATS_COLLECTOR = "statsCollector";
    private RelayConfig relayConfig;
    private List<ProducerRegistration> producerRegistrationList = new ArrayList<ProducerRegistration>();
    private RelayEventProducersRegistry producersRegistry;
    private MultiServerSequenceNumberHandler maxScnReaderWriters;

    public DefaultRelay getObject() throws Exception {
        HttpRelay.Config config = new HttpRelay.Config();
        ConfigLoader staticConfigLoader = new ConfigLoader("databus.relay.", (ConfigBuilder)config);
        PhysicalSourceStaticConfig[] pStaticConfigs = new PhysicalSourceStaticConfig[this.producerRegistrationList.size()];
        int i = 0;
        while (i < this.producerRegistrationList.size()) {
            pStaticConfigs[i] = this.producerRegistrationList.get(i).getPhysicalSourceConfig().build();
            for (LogicalSourceConfig logicalSourceConfig : this.producerRegistrationList.get(i).getPhysicalSourceConfig().getSources()) {
                config.setSourceName(String.valueOf(logicalSourceConfig.getId()), logicalSourceConfig.getName());
            }
            ++i;
        }
        HttpRelay.StaticConfig staticConfig = (HttpRelay.StaticConfig)staticConfigLoader.loadConfig((Map)this.relayConfig.getRelayProperties());
        FileSystemSchemaRegistryService.Config configBuilder = new FileSystemSchemaRegistryService.Config();
        configBuilder.setFallbackToResources(true);
        configBuilder.setSchemaDir(this.getRelayConfig().getSchemaRegistryLocation());
        FileSystemSchemaRegistryService.StaticConfig schemaRegistryServiceConfig = configBuilder.build();
        FileSystemSchemaRegistryService schemaRegistryService = FileSystemSchemaRegistryService.build((FileSystemSchemaRegistryService.StaticConfig)schemaRegistryServiceConfig);
        DefaultRelay relay = new DefaultRelay(staticConfig, pStaticConfigs, SourceIdNameRegistry.createFromIdNamePairs((Collection)staticConfig.getSourceIds()), (SchemaRegistryService)schemaRegistryService);
        if (this.maxScnReaderWriters == null) {
            SequenceNumberHandlerFactory handlerFactory = staticConfig.getDataSources().getSequenceNumbersHandler().createFactory();
            this.maxScnReaderWriters = new MultiServerSequenceNumberHandler(handlerFactory);
            relay.setMaxScnReaderWriters(this.maxScnReaderWriters);
        }
        int i2 = 0;
        while (i2 < this.producerRegistrationList.size()) {
            ProducerRegistration producerRegistration = this.producerRegistrationList.get(i2);
            PhysicalSourceStaticConfig pStaticConfig = pStaticConfigs[i2];
            if (AbstractEventProducer.class.isAssignableFrom(producerRegistration.getEventProducer().getClass())) {
                AbstractEventProducer producer = (AbstractEventProducer)producerRegistration.getEventProducer();
                DbusEventBufferAppendable eb = relay.getEventBuffer().getDbusEventBufferAppendable((int)pStaticConfig.getSources()[0].getId());
                producer.setEventBuffer(new ProducerEventBuffer(producer.getName(), eb, relay.getMetricsCollector()));
                producer.setMaxScnReaderWriter(this.maxScnReaderWriters.getOrCreateHandler((NamedObject)pStaticConfig.getPhysicalPartition()));
                producer.setSchemaRegistryService(relay.getSchemaRegistryService());
                producer.setDbusEventsStatisticsCollector(relay.getInboundEventStatisticsCollector());
            }
            ++i2;
        }
        relay.setProducerRegistrationList(this.producerRegistrationList);
        return relay;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.relayConfig, (String)"'relayConfig' cannot be null. This Relay will not be initialized");
        Assert.notEmpty(this.producerRegistrationList, (String)"'producerRegistrationList' cannot be empty. No Event producers registered");
    }

    public Class<DefaultRelay> getObjectType() {
        return DefaultRelay.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public RelayEventProducersRegistry getProducersRegistry() {
        return this.producersRegistry;
    }

    public void setProducersRegistry(RelayEventProducersRegistry producersRegistry) {
        this.producersRegistry = producersRegistry;
    }

    public MultiServerSequenceNumberHandler getMaxScnReaderWriters() {
        return this.maxScnReaderWriters;
    }

    public void setMaxScnReaderWriters(MultiServerSequenceNumberHandler maxScnReaderWriters) {
        this.maxScnReaderWriters = maxScnReaderWriters;
    }

    public RelayConfig getRelayConfig() {
        return this.relayConfig;
    }

    public void setRelayConfig(RelayConfig relayConfig) {
        this.relayConfig = relayConfig;
    }

    public void setProducerRegistrationList(List<ProducerRegistration> producerRegistrationList) {
        this.producerRegistrationList = producerRegistrationList;
    }

    public List<ProducerRegistration> getProducerRegistrationList() {
        return this.producerRegistrationList;
    }
}

