/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.runtime.relay.netty;

import com.flipkart.aesop.runtime.relay.DefaultRelay;
import com.linkedin.databus.core.Checkpoint;
import com.linkedin.databus.core.monitoring.mbean.DbusEventsStatisticsCollector;
import com.linkedin.databus2.core.container.monitoring.mbean.HttpStatisticsCollector;
import com.linkedin.databus2.core.container.request.DatabusRequest;
import java.net.InetSocketAddress;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class RelayStatisticsCollectingHandler
extends SimpleChannelHandler {
    protected static final Logger LOGGER = LogFactory.getLogger(RelayStatisticsCollectingHandler.class);
    private DbusEventsStatisticsCollector outEventStatsCollector;
    private DbusEventsStatisticsCollector connOutEventStatsCollector;
    private HttpStatisticsCollector outHttpStatsCollector;
    private HttpStatisticsCollector connOutHttpStatsCollector;
    private DatabusRequest latestDbusRequest = null;
    private DefaultRelay relay;
    private String client = null;

    public RelayStatisticsCollectingHandler(DefaultRelay relay) {
        this.relay = relay;
        this.outEventStatsCollector = relay.getOutboundEventStatisticsCollector();
        this.outHttpStatsCollector = relay.getHttpStatisticsCollector();
        this.connOutEventStatsCollector = null;
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (null != this.outEventStatsCollector || null != this.outHttpStatsCollector) {
            InetSocketAddress inetAddress;
            Object value = e.getValue();
            this.client = value instanceof InetSocketAddress ? ((inetAddress = (InetSocketAddress)value).getAddress().isLoopbackAddress() ? "localhost" : inetAddress.getAddress().getHostAddress()) : e.getValue().toString();
            if (null != this.outEventStatsCollector) {
                this.connOutEventStatsCollector = this.outEventStatsCollector.createForPeerConnection(this.client);
            }
            if (null != this.outHttpStatsCollector) {
                this.connOutHttpStatsCollector = this.outHttpStatsCollector.createForClientConnection(this.client);
            }
        }
        this.relay.firePeerConnect(this.client);
        super.channelConnected(ctx, e);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        try {
            if (null != this.outEventStatsCollector || null != this.outHttpStatsCollector) {
                if (e.getMessage() instanceof DatabusRequest) {
                    this.latestDbusRequest = (DatabusRequest)e.getMessage();
                    if (null != this.outEventStatsCollector) {
                        this.latestDbusRequest.getParams().put(this.outEventStatsCollector.getName(), this.connOutEventStatsCollector);
                    }
                    if (null != this.outHttpStatsCollector) {
                        this.latestDbusRequest.getParams().put(this.outHttpStatsCollector.getName(), this.connOutHttpStatsCollector);
                    }
                    if (this.latestDbusRequest.getParams().getProperty("checkPoint") != null) {
                        Checkpoint cp = new Checkpoint(this.latestDbusRequest.getParams().getProperty("checkPoint"));
                        String peer = (String)this.connOutHttpStatsCollector.getPeers().get(0);
                        this.connOutHttpStatsCollector.getPeerStats(peer).registerStreamRequest(peer, cp);
                        this.relay.getMetricsCollector().setClientSCN(peer, cp.getWindowScn());
                    }
                } else if (this.shouldMerge(e)) {
                    this.mergePerConnStats();
                }
            }
            super.messageReceived(ctx, e);
        }
        catch (Exception ex) {
            LOGGER.error("Exception while processing message in RelayStatisticsCollectingHandler");
        }
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (null != this.connOutEventStatsCollector || null != this.connOutHttpStatsCollector) {
            this.mergePerConnStats();
            if (null != this.connOutEventStatsCollector) {
                this.connOutEventStatsCollector.unregisterMBeans();
            }
            if (null != this.connOutHttpStatsCollector) {
                this.connOutHttpStatsCollector.unregisterMBeans();
            }
            this.connOutEventStatsCollector = null;
            this.connOutHttpStatsCollector = null;
        }
        this.latestDbusRequest = null;
        this.relay.firePeerDisconnect(this.client);
        super.channelClosed(ctx, e);
    }

    private boolean shouldMerge(MessageEvent me) {
        return me.getMessage() instanceof HttpChunkTrailer || me.getMessage() instanceof HttpResponse;
    }

    private void mergePerConnStats() {
        if (null != this.connOutEventStatsCollector) {
            this.outEventStatsCollector.merge(this.connOutEventStatsCollector);
            this.connOutEventStatsCollector.reset();
        }
        if (null != this.connOutHttpStatsCollector) {
            this.outHttpStatsCollector.merge(this.connOutHttpStatsCollector);
            this.connOutHttpStatsCollector.reset();
        }
    }
}

