/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.runtime.spring.web;

import java.util.HashMap;
import java.util.Map;

public class RelayInfo {
    private int pSourceId;
    private String pSourceName;
    private String pSourceURI;
    private String producerName;
    private String producerSinceSCN;
    private ClientInfo[] clientInfos;
    private LSourceInfo[] lSourceInfos;
    private Map<String, Map> hostGroupedClient;

    public RelayInfo(int pSourceId, String pSourceName, String pSourceURI) {
        this.pSourceId = pSourceId;
        this.pSourceName = pSourceName;
        this.pSourceURI = pSourceURI;
    }

    public String getProducerName() {
        return this.producerName;
    }

    public void setProducerName(String producerName) {
        this.producerName = producerName;
    }

    public String getProducerSinceSCN() {
        return this.producerSinceSCN;
    }

    public void setProducerSinceSCN(String producerSinceSCN) {
        this.producerSinceSCN = producerSinceSCN;
    }

    public int getpSourceId() {
        return this.pSourceId;
    }

    public String getpSourceName() {
        return this.pSourceName;
    }

    public String getpSourceURI() {
        return this.pSourceURI;
    }

    public ClientInfo[] getClientInfos() {
        return this.clientInfos;
    }

    public void setClientInfos(ClientInfo[] clientInfos) {
        this.clientInfos = clientInfos;
    }

    public LSourceInfo[] getlSourceInfos() {
        return this.lSourceInfos;
    }

    public void setlSourceInfos(LSourceInfo[] lSourceInfos) {
        this.lSourceInfos = lSourceInfos;
    }

    public Map getHostGroupedClient() {
        return this.hostGroupedClient;
    }

    public void setHostGroupedClient() {
        this.hostGroupedClient = new HashMap<String, Map>();
        for (ClientInfo clientInfo : this.clientInfos) {
            Long clientSCN = clientInfo.getClientSinceSCN();
            String clientHost = clientInfo.getClientHost();
            HashMap<String, Long> clientHostSCN = this.hostGroupedClient.get(clientHost);
            if (clientHostSCN == null) {
                clientHostSCN = new HashMap<String, Long>();
            }
            if (clientHostSCN.get("MIN") == null || (Long)clientHostSCN.get("MIN") > clientSCN) {
                clientHostSCN.put("MIN", clientSCN);
            }
            if (clientHostSCN.get("MAX") == null || (Long)clientHostSCN.get("MAX") < clientSCN) {
                clientHostSCN.put("MAX", clientSCN);
            }
            this.hostGroupedClient.put(clientHost, clientHostSCN);
        }
    }

    public static class LSourceInfo {
        private int lSourceId;
        private String lSourceName;
        private String lSourceURI;

        public LSourceInfo(int lSourceId) {
            this.lSourceId = lSourceId;
        }

        public int getLSourceId() {
            return this.lSourceId;
        }

        public void setLSourceId(int lSourceId) {
            this.lSourceId = lSourceId;
        }

        public String getLSourceName() {
            return this.lSourceName;
        }

        public void setLSourceName(String lSourceName) {
            this.lSourceName = lSourceName;
        }

        public String getLSourceURI() {
            return this.lSourceURI;
        }

        public void setLSourceURI(String lSourceURI) {
            this.lSourceURI = lSourceURI;
        }
    }

    public static class ClientInfo {
        private String clientName;
        private String clientHost;
        private Long clientSinceSCN;

        public ClientInfo(String clientName) {
            this.clientName = clientName;
            this.clientHost = ClientInfo.parseHostFromClientName(this.clientName);
        }

        public String getClientName() {
            return this.clientName;
        }

        public String getClientHost() {
            return this.clientHost;
        }

        public void setClientSinceSCN(Long clientSinceSCN) {
            this.clientSinceSCN = clientSinceSCN;
        }

        public Long getClientSinceSCN() {
            return this.clientSinceSCN;
        }

        public static String parseHostFromClientName(String clientName) {
            return clientName.replaceAll("(.*)-(\\d+)", "$1");
        }
    }
}

