/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.runtime.metrics;

import com.flipkart.aesop.runtime.relay.DefaultRelay;
import com.flipkart.aesop.runtime.spring.web.RelayInfo;
import com.linkedin.databus.core.monitoring.mbean.DbusEventsTotalStats;
import com.linkedin.databus2.core.container.monitoring.mbean.DbusHttpTotalStats;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.codehaus.jackson.map.ObjectMapper;

public class MetricsCollector {
    private static final int DEFAULT_REFRESH_INTERVAL = 1;
    private DefaultRelay relay;
    private ScheduledExecutorService scheduledExecutorService;
    private ObjectMapper objectMapper = new ObjectMapper();
    private String json = "";
    private int refreshInterval = 1;
    private DbusHttpTotalStats httpTotalStats;
    private DbusEventsTotalStats inboundTotalStats;
    private DbusEventsTotalStats outboundTotalStats;
    private Map<String, Long> producerSCN = new HashMap<String, Long>();
    private Map<String, Long> clientSCN = new HashMap<String, Long>();

    public MetricsCollector(DefaultRelay relay) {
        this.relay = relay;
        this.httpTotalStats = relay.getHttpStatisticsCollector().getTotalStats();
        this.inboundTotalStats = relay.getInboundEventStatisticsCollector().getTotalStats();
        this.outboundTotalStats = relay.getOutboundEventStatisticsCollector().getTotalStats();
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        this.scheduledExecutorService.scheduleAtFixedRate(new Encoder(this), 0L, 1L, TimeUnit.SECONDS);
    }

    public void setClientSCN(String client, long SCN) {
        this.clientSCN.put(client, SCN);
    }

    public void setProducerSCN(String producer, long SCN) {
        this.producerSCN.put(producer, SCN);
    }

    public String getJson() {
        return this.json;
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public class Encoder
    implements Runnable {
        private MetricsCollector collector;

        public Encoder(MetricsCollector collector) {
            this.collector = collector;
        }

        @Override
        public void run() {
            HashMap map = new HashMap();
            map.put("producer", this.collector.producerSCN);
            HashMap<String, Long> connectedClientSCN = new HashMap<String, Long>();
            HashMap<String, Long> groupHostClient = new HashMap<String, Long>();
            Long clientSCN = null;
            String clientHost = null;
            for (String client : MetricsCollector.this.relay.getPeers()) {
                String clientHostMaxKey;
                clientSCN = (Long)this.collector.clientSCN.get(client);
                clientHost = RelayInfo.ClientInfo.parseHostFromClientName(client);
                String clientHostMinKey = String.valueOf(clientHost) + "-min";
                if (groupHostClient.get(clientHostMinKey) == null || (Long)groupHostClient.get(clientHostMinKey) >= clientSCN) {
                    groupHostClient.put(clientHostMinKey, clientSCN);
                }
                if (groupHostClient.get(clientHostMaxKey = String.valueOf(clientHost) + "-max") == null || (Long)groupHostClient.get(clientHostMaxKey) < clientSCN) {
                    groupHostClient.put(clientHostMaxKey, clientSCN);
                }
                connectedClientSCN.put(client, clientSCN);
            }
            map.put("clientHost", groupHostClient);
            map.put("client", connectedClientSCN);
            map.put("http", this.collector.httpTotalStats);
            map.put("inbound", this.collector.inboundTotalStats);
            map.put("outbound", this.collector.outboundTotalStats);
            try {
                this.collector.json = this.collector.objectMapper.writeValueAsString(map);
            }
            catch (Exception e) {
                this.collector.json = this.mapException(e);
            }
        }

        private String mapException(Exception e) {
            try {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("status", "exception");
                map.put("class", e.getClass().getName());
                map.put("message", e.getMessage());
                return MetricsCollector.this.objectMapper.writeValueAsString(map);
            }
            catch (Exception x) {
                return "";
            }
        }
    }
}

