/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.runtime.config;

import java.io.File;
import java.util.Properties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.trpr.platform.core.PlatformException;
import org.trpr.platform.runtime.common.RuntimeVariables;
import org.trpr.platform.runtime.impl.config.FileLocator;

public class RelayConfig
implements InitializingBean {
    public static final String RELAY_PROPERTIES_PREFIX = "databus.relay.";
    public static final String MMAPPED_DIR_PROPERTY = "eventBuffer.mmapDirectory";
    public static final String MAXSCN_DIR_PROPERTY = "dataSources.sequenceNumbersHandler.file.scnDir";
    private Properties relayProperties = new Properties();
    private String schemaRegistryLocation;
    private String mmappedDirectoryLocation;
    private String maxScnDirectoryLocation;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.schemaRegistryLocation, (String)"'schemaRegistryLocation' cannot be null. This Relay will not be initialized");
        Assert.notNull((Object)this.mmappedDirectoryLocation, (String)"'mmappedDirectoryLocation' cannot be null. This Relay will not be initialized");
        Assert.notNull((Object)this.maxScnDirectoryLocation, (String)"'maxScnDirectoryLocation' cannot be null. This Relay will not be initialized");
        for (Object key : this.relayProperties.keySet()) {
            if (((String)key).startsWith(RELAY_PROPERTIES_PREFIX)) continue;
            throw new PlatformException("Property : " + key + " does not begin with the prefix : " + RELAY_PROPERTIES_PREFIX);
        }
    }

    public Properties getRelayProperties() {
        return this.relayProperties;
    }

    public void setRelayProperties(Properties relayProperties) {
        this.relayProperties = relayProperties;
    }

    public String getSchemaRegistryLocation() {
        return this.schemaRegistryLocation;
    }

    public void setSchemaRegistryLocation(String schemaRegistryLocation) {
        File[] foundFiles = FileLocator.findDirectories((String)schemaRegistryLocation, null);
        this.schemaRegistryLocation = foundFiles.length > 0 ? foundFiles[0].getAbsolutePath() : schemaRegistryLocation;
    }

    public String getMmappedDirectoryLocation() {
        return this.mmappedDirectoryLocation;
    }

    public void setMmappedDirectoryLocation(String mmappedDirectoryLocation) {
        this.mmappedDirectoryLocation = mmappedDirectoryLocation;
        this.getRelayProperties().put("databus.relay.eventBuffer.mmapDirectory", new File(String.valueOf(RuntimeVariables.getProjectsRoot()) + File.separator + this.mmappedDirectoryLocation).getAbsolutePath());
    }

    public String getMaxScnDirectoryLocation() {
        return this.maxScnDirectoryLocation;
    }

    public void setMaxScnDirectoryLocation(String maxScnDirectoryLocation) {
        this.maxScnDirectoryLocation = maxScnDirectoryLocation;
        this.getRelayProperties().put("databus.relay.dataSources.sequenceNumbersHandler.file.scnDir", new File(String.valueOf(RuntimeVariables.getProjectsRoot()) + File.separator + this.maxScnDirectoryLocation).getAbsolutePath());
    }
}

