/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.runtime.producer.impl;

import com.linkedin.databus.client.pub.CheckpointPersistenceProvider;
import com.linkedin.databus.client.pub.FileSystemCheckpointPersistenceProvider;
import java.io.File;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.trpr.platform.runtime.common.RuntimeVariables;

public class FileSystemCPProviderFactory
implements FactoryBean<CheckpointPersistenceProvider>,
InitializingBean {
    private static final int DEFAULT_PROTOCOL_VERSION = 2;
    private String checkpointDir;
    private int maxHistorySize = 99;

    public CheckpointPersistenceProvider getObject() throws Exception {
        FileSystemCheckpointPersistenceProvider.Config config = new FileSystemCheckpointPersistenceProvider.Config();
        config.setRootDirectory(new File(String.valueOf(RuntimeVariables.getProjectsRoot()) + File.separator + this.checkpointDir).getAbsolutePath());
        config.getRuntime().setHistoryEnabled(true);
        config.getRuntime().setHistorySize(this.maxHistorySize);
        FileSystemCheckpointPersistenceProvider checkpointProvider = new FileSystemCheckpointPersistenceProvider(config, 2);
        return checkpointProvider;
    }

    public Class<CheckpointPersistenceProvider> getObjectType() {
        return CheckpointPersistenceProvider.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.checkpointDir, (String)"'checkpointDir' cannot be null. This file based checkpoint provider will not be initialized");
    }

    public String getCheckpointDir() {
        return this.checkpointDir;
    }

    public void setCheckpointDir(String checkpointDir) {
        this.checkpointDir = checkpointDir;
    }

    public int getMaxHistorySize() {
        return this.maxHistorySize;
    }

    public void setMaxHistorySize(int maxHistorySize) {
        this.maxHistorySize = maxHistorySize;
    }
}

