/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.serializer.batch.writer;

import com.flipkart.aesop.serializer.stateengine.StateTransitioner;
import java.util.List;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class StateEngineApenderWriter<T>
implements ItemWriter<T>,
InitializingBean {
    private static final Logger LOGGER = LogFactory.getLogger(StateEngineApenderWriter.class);
    private StateTransitioner<T> stateTransitioner;

    public void write(List<? extends T> items) throws Exception {
        for (T item : items) {
            this.stateTransitioner.getStateEngine().add(item.getClass().getName(), item);
        }
        LOGGER.debug("Appended {} items of type {} to Fast blob state engine", (Object)items.size(), (Object)items.get(0).getClass().getName());
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.stateTransitioner, (String)"'stateTransitioner' cannot be null. This State engine appender writer will not be initialized");
    }

    public StateTransitioner<T> getStateTransitioner() {
        return this.stateTransitioner;
    }

    public void setStateTransitioner(StateTransitioner<T> stateTransitioner) {
        this.stateTransitioner = stateTransitioner;
    }
}

