/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.serializer.stateengine;

import com.netflix.zeno.fastblob.FastBlobStateEngine;
import com.netflix.zeno.serializer.NFTypeSerializer;
import com.netflix.zeno.serializer.SerializerFactory;
import java.io.File;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public abstract class StateTransitioner<T>
implements InitializingBean {
    protected SerializerFactory serializerFactory;
    protected NFTypeSerializer<T> rootNFTypeSerializer;
    protected String serializedDataLocation;
    protected File serializedDataLocationDir;

    public abstract FastBlobStateEngine getStateEngine();

    public abstract void saveState();

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.serializerFactory, (String)"'serializerFactory' cannot be null. This state transitioner will not be initialized");
        Assert.notNull(this.rootNFTypeSerializer, (String)"'rootNFTypeSerializer' cannot be null. This state transitioner will not be initialized");
        Assert.notNull((Object)this.serializedDataLocation, (String)"'serializedDataLocation' cannot be null. This state transitioner will not be initialized");
        this.serializedDataLocationDir = new File(this.serializedDataLocation);
        if (!this.serializedDataLocationDir.exists()) {
            this.serializedDataLocationDir.mkdirs();
        }
    }

    public void setSerializerFactory(SerializerFactory serializerFactory) {
        this.serializerFactory = serializerFactory;
    }

    public void setRootNFTypeSerializer(NFTypeSerializer<T> rootNFTypeSerializer) {
        this.rootNFTypeSerializer = rootNFTypeSerializer;
    }

    public void setSerializedDataLocation(String serializedDataLocation) {
        this.serializedDataLocation = serializedDataLocation;
    }

    public String getSerializedDataLocation() {
        return this.serializedDataLocation;
    }
}

