/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.runtime.impl.registry;

import com.flipkart.aesop.runtime.spi.registry.AbstractRuntimeRegistry;
import com.flipkart.aesop.runtime.spring.registry.ServerContainerConfigInfo;
import com.linkedin.databus2.core.container.netty.ServerContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.trpr.platform.core.PlatformException;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class ServerContainerRegistry
implements AbstractRuntimeRegistry {
    private static Logger LOGGER = LogFactory.getLogger(ServerContainerRegistry.class);
    private Map<String, ServerContainer> runtimes = new HashMap<String, ServerContainer>();

    @Override
    public AbstractRuntimeRegistry.InitedRuntimeInfo[] init(List<ServerContainerConfigInfo> serverContainerConfigList) throws Exception {
        LinkedList<AbstractRuntimeRegistry.InitedRuntimeInfo> initedRuntimeInfos = new LinkedList<AbstractRuntimeRegistry.InitedRuntimeInfo>();
        for (ServerContainerConfigInfo serverContainerConfigInfo : serverContainerConfigList) {
            String[] runtimeBeanIds;
            for (String runtimeBeanId : runtimeBeanIds = serverContainerConfigInfo.getRuntimeContext().getBeanNamesForType(ServerContainer.class)) {
                ServerContainer runtime = (ServerContainer)serverContainerConfigInfo.getRuntimeContext().getBean(runtimeBeanId);
                try {
                    LOGGER.info("Initializing ServerContainer: " + runtime.getComponentAdmin().getComponentName());
                    runtime.start();
                    initedRuntimeInfos.add(new AbstractRuntimeRegistry.InitedRuntimeInfo(runtime, serverContainerConfigInfo));
                }
                catch (Exception e) {
                    LOGGER.error("Error initializing ServerContainer {}. Error is: " + e.getMessage(), (Object)runtime.getComponentAdmin().getComponentName(), (Object)e);
                    throw new PlatformException("Error initializing ServerContainer: " + runtime.getComponentAdmin().getComponentName(), (Throwable)e);
                }
                this.runtimes.put(runtime.getComponentAdmin().getComponentName(), runtime);
            }
        }
        return initedRuntimeInfos.toArray(new AbstractRuntimeRegistry.InitedRuntimeInfo[0]);
    }

    @Override
    public void reinitRuntime(String name) throws Exception {
        ServerContainer runtime = this.runtimes.get(name);
        if (runtime != null) {
            try {
                runtime.shutdown();
                runtime.start();
            }
            catch (Exception e) {
                LOGGER.error("Error initializing ServerContainer {}. Error is: " + e.getMessage(), (Object)name, (Object)e);
                throw new PlatformException("Error reinitialising ServerContainer: " + name, (Throwable)e);
            }
        }
    }

    @Override
    public void shutdown() throws Exception {
        for (String name : this.runtimes.keySet()) {
            try {
                LOGGER.info("Shutting down ServerContainer: " + name);
                this.runtimes.get(name).shutdown();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to shutdown ServerContainer: " + name, (Throwable)e);
            }
        }
    }

    @Override
    public List<ServerContainer> getRuntimes() {
        return new ArrayList<ServerContainer>(this.runtimes.values());
    }

    @Override
    public ServerContainer getRuntime(String name) {
        return this.runtimes.get(name);
    }

    @Override
    public void unregisterRuntime(ServerContainer runtime) {
        this.runtimes.remove(runtime.getComponentAdmin().getComponentName());
    }
}

