/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.runtime.spring.registry;

import java.io.File;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class ServerContainerConfigInfo {
    public static final String BINARIES_PATH = "lib";
    public static final String FILE_PREFIX = "file:";
    private File xmlConfigFile;
    private String binariesPath = "lib";
    private AbstractApplicationContext runtimeContext;

    public ServerContainerConfigInfo(File xmlConfigFile) {
        this.xmlConfigFile = xmlConfigFile;
    }

    public ServerContainerConfigInfo(File xmlConfigFile, String binariesPath) {
        this(xmlConfigFile);
        this.binariesPath = binariesPath;
    }

    public ServerContainerConfigInfo(File xmlConfigFile, String binariesPath, AbstractApplicationContext runtimeContext) {
        this(xmlConfigFile, binariesPath);
        this.runtimeContext = runtimeContext;
    }

    public AbstractApplicationContext loadRuntimeContext(ClassLoader classLoader, AbstractApplicationContext applicationContext) {
        ClassLoader existingTCCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        this.runtimeContext = new FileSystemXmlApplicationContext(new String[]{FILE_PREFIX + this.xmlConfigFile.getAbsolutePath()}, (ApplicationContext)applicationContext);
        Thread.currentThread().setContextClassLoader(existingTCCL);
        return this.runtimeContext;
    }

    public boolean equals(Object object) {
        ServerContainerConfigInfo otherConfigInfo = (ServerContainerConfigInfo)object;
        return this.getXmlConfigFile().getAbsolutePath().equalsIgnoreCase(otherConfigInfo.getXmlConfigFile().getAbsolutePath());
    }

    public String toString() {
        return "ServerContainerConfigInfo [xmlConfigFile=" + this.xmlConfigFile + ", binariesPath=" + this.binariesPath + "]";
    }

    public AbstractApplicationContext getRuntimeContext() {
        return this.runtimeContext;
    }

    public File getXmlConfigFile() {
        return this.xmlConfigFile;
    }

    public String getBinariesPath() {
        return this.binariesPath;
    }
}

