/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.sample.client.common.events;

import com.flipkart.aesop.sample.client.common.events.MysqlBinLogEvent;
import com.flipkart.aesop.sample.client.common.utils.AvroToMysqlMapper;
import com.flipkart.aesop.sample.client.common.utils.MysqlDataTypes;
import com.linkedin.databus.client.pub.DbusEventDecoder;
import com.linkedin.databus.core.DbusEvent;
import com.linkedin.databus.core.DbusOpcode;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.schemas.VersionedSchema;
import com.linkedin.databus2.schemas.utils.SchemaHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MysqlBinLogEventImpl
implements MysqlBinLogEvent {
    private static String PK_FIELD_NAME = "pk";
    private static String META_FIELD_TYPE_NAME = "dbFieldType";
    private Schema schema;
    private List<String> pKeyList = new ArrayList<String>(3);
    private Map<String, Object> keyValuePairs = new HashMap<String, Object>();
    private DbusOpcode eventType;

    public MysqlBinLogEventImpl(DbusEvent event, DbusEventDecoder eventDecoder) throws DatabusException {
        GenericRecord genericRecord = eventDecoder.getGenericRecord(event, null);
        VersionedSchema writerSchema = eventDecoder.getPayloadSchema(event);
        this.schema = writerSchema.getSchema();
        this.eventType = event.getOpcode();
        this.pKeyList = this.getPkListFromSchema(this.schema);
        for (Schema.Field field : this.schema.getFields()) {
            String mysqlType = SchemaHelper.getMetaField((Schema.Field)field, (String)META_FIELD_TYPE_NAME);
            this.keyValuePairs.put(field.name(), AvroToMysqlMapper.avroToMysqlType(genericRecord.get(field.name()), MysqlDataTypes.valueOf(mysqlType.toUpperCase())));
        }
    }

    public MysqlBinLogEventImpl(Schema schema, Map<String, Object> keyValuePairs, DbusOpcode eventType) throws DatabusException {
        this.eventType = eventType;
        this.keyValuePairs = keyValuePairs;
        this.pKeyList = this.getPkListFromSchema(schema);
        this.schema = schema;
    }

    private List<String> getPkListFromSchema(Schema schema) throws DatabusException {
        ArrayList<String> pKeyList = new ArrayList<String>(3);
        String pkFieldName = SchemaHelper.getMetaField((Schema)schema, (String)PK_FIELD_NAME);
        if (pkFieldName == null) {
            throw new DatabusException("No primary key specified in the schema");
        }
        for (String s : pkFieldName.split(",")) {
            pKeyList.add(s.trim());
        }
        assert (pKeyList.size() >= 1);
        return pKeyList;
    }

    @Override
    public Map<String, Object> getKeyValuePair() {
        return this.keyValuePairs;
    }

    @Override
    public Object get(String key) {
        return this.keyValuePairs.get(key);
    }

    @Override
    public boolean isCompositeKey() {
        return this.pKeyList.size() > 1;
    }

    @Override
    public List<String> getPrimaryKeyList() {
        return this.pKeyList;
    }

    @Override
    public List<Object> getPrimaryKeyValues() {
        ArrayList<Object> primaryKeyValues = new ArrayList<Object>();
        for (int i = 0; i < this.pKeyList.size(); ++i) {
            primaryKeyValues.add(this.keyValuePairs.get(this.pKeyList.get(i)));
        }
        return primaryKeyValues;
    }

    @Override
    public String getEntityName() {
        return this.schema.getNamespace() + "." + this.schema.getName();
    }

    @Override
    public DbusOpcode getEventType() {
        return this.eventType;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MysqlBinLogEventImpl [");
        builder.append("entityName : " + this.getEntityName() + ", ");
        builder.append("eventType : " + this.getEventType().toString() + ", ");
        builder.append("pKeyList : " + this.getPrimaryKeyList().toString() + ", ");
        builder.append("keyValuePairs : " + this.getKeyValuePair().toString());
        return builder.toString();
    }
}

