/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.relay.sample;

import com.flipkart.aesop.events.sample.person.FieldChange;
import com.flipkart.aesop.events.sample.person.Person;
import com.flipkart.aesop.runtime.producer.hbase.SepEventMapper;
import com.ngdata.sep.SepEvent;
import java.util.LinkedList;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.util.Bytes;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class PersonSepEventMapper
implements SepEventMapper<Person> {
    protected static final Logger LOGGER = LogFactory.getLogger(PersonSepEventMapper.class);

    public String getUniqueName() {
        return this.getClass().getCanonicalName();
    }

    public Person mapSepEvent(SepEvent sepEvent) {
        String firstName = null;
        String lastName = null;
        long dob = 0L;
        String deleted = "false";
        for (KeyValue kv : sepEvent.getKeyValues()) {
            if (kv.isDeleteFamily()) {
                LOGGER.debug("Returning Delete Person object : " + sepEvent.getRow() + " " + deleted);
                return new Person(Bytes.toLong((byte[])sepEvent.getRow()), "", "", 0L, "true", new LinkedList<FieldChange>());
            }
            String columnQualifier = new String(kv.getQualifier());
            if (columnQualifier.equalsIgnoreCase("firstName")) {
                firstName = Bytes.toString((byte[])kv.getValue());
                continue;
            }
            if (columnQualifier.equalsIgnoreCase("lastName")) {
                lastName = Bytes.toString((byte[])kv.getValue());
                continue;
            }
            if (!columnQualifier.equalsIgnoreCase("birthDate")) continue;
            dob = Bytes.toLong((byte[])kv.getValue());
        }
        LOGGER.debug("Returning Person object : " + sepEvent.getRow() + " " + firstName + " " + lastName);
        return new Person(Bytes.toLong((byte[])sepEvent.getRow()), firstName, lastName, dob, deleted, new LinkedList<FieldChange>());
    }
}

