/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.serializer.serializers;

import com.flipkart.aesop.serializer.model.UserAddressInfo;
import com.netflix.zeno.fastblob.record.schema.FastBlobSchema;
import com.netflix.zeno.serializer.NFDeserializationRecord;
import com.netflix.zeno.serializer.NFSerializationRecord;
import com.netflix.zeno.serializer.NFTypeSerializer;
import com.netflix.zeno.serializer.common.MapSerializer;
import com.netflix.zeno.serializer.common.StringSerializer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.core.serializer.support.SerializationFailedException;

public class UserAddressInfoSerializer
extends NFTypeSerializer<UserAddressInfo> {
    private ObjectMapper objectMapper = new ObjectMapper();

    public UserAddressInfoSerializer() {
        super(UserAddressInfo.class.getName());
    }

    protected FastBlobSchema createSchema() {
        return this.schema(new NFTypeSerializer.FastBlobSchemaField[]{this.field("id", FastBlobSchema.FieldType.STRING), this.field("account_id", FastBlobSchema.FieldType.STRING), this.field("first_name", FastBlobSchema.FieldType.STRING), this.field("last_name", FastBlobSchema.FieldType.STRING), this.field("address_line1", FastBlobSchema.FieldType.STRING), this.field("address_line2", FastBlobSchema.FieldType.STRING), this.field("landmark", FastBlobSchema.FieldType.STRING), this.field("city", FastBlobSchema.FieldType.STRING), this.field("state", FastBlobSchema.FieldType.STRING), this.field("state_code", FastBlobSchema.FieldType.STRING), this.field("country", FastBlobSchema.FieldType.STRING), this.field("pincode", FastBlobSchema.FieldType.STRING), this.field("phone", FastBlobSchema.FieldType.STRING), this.field("guest", FastBlobSchema.FieldType.BOOLEAN), this.field("active", FastBlobSchema.FieldType.BOOLEAN), this.field("version", FastBlobSchema.FieldType.INT), this.field("creation_date", FastBlobSchema.FieldType.STRING), this.field("last_modified", FastBlobSchema.FieldType.STRING), this.field("creating_system", FastBlobSchema.FieldType.STRING), this.field("preferences", "MapOfPreferences")});
    }

    protected UserAddressInfo doDeserialize(NFDeserializationRecord record) {
        String id = this.deserializePrimitiveString(record, "id");
        String account_id = this.deserializePrimitiveString(record, "account_id");
        String first_name = this.deserializePrimitiveString(record, "first_name");
        String last_name = this.deserializePrimitiveString(record, "last_name");
        String address_line1 = this.deserializePrimitiveString(record, "address_line1");
        String address_line2 = this.deserializePrimitiveString(record, "address_line2");
        String landmark = this.deserializePrimitiveString(record, "landmark");
        String city = this.deserializePrimitiveString(record, "city");
        String state = this.deserializePrimitiveString(record, "state");
        String state_code = this.deserializePrimitiveString(record, "id");
        String country = this.deserializePrimitiveString(record, "country");
        String pincode = this.deserializePrimitiveString(record, "pincode");
        String phone = this.deserializePrimitiveString(record, "phone");
        boolean guest = this.deserializeBoolean(record, "guest");
        boolean active = this.deserializeBoolean(record, "active");
        int version = this.deserializeInteger(record, "version");
        String creation_date = this.deserializePrimitiveString(record, "creation_date");
        String last_modified = this.deserializePrimitiveString(record, "last_modified");
        String creating_system = this.deserializePrimitiveString(record, "creating_system");
        Map preferences = (Map)this.deserializeObject(record, "preferences");
        return new UserAddressInfo(id, account_id, first_name, last_name, address_line1, address_line2, landmark, city, state, state_code, country, pincode, phone, guest, active, version, creation_date, last_modified, creating_system, preferences);
    }

    public void doSerialize(UserAddressInfo userAddressInfo, NFSerializationRecord record) {
        this.serializePrimitive(record, "id", userAddressInfo.getId());
        this.serializePrimitive(record, "account_id", userAddressInfo.getAccount_id());
        this.serializeObject(record, "preferences", userAddressInfo.getPreferences());
        this.serializePrimitive(record, "first_name", userAddressInfo.getFirst_name());
        this.serializePrimitive(record, "last_name", userAddressInfo.getLast_name());
        this.serializePrimitive(record, "address_line1", userAddressInfo.getAddress_line1());
        this.serializePrimitive(record, "address_line2", userAddressInfo.getAddress_line2());
        this.serializePrimitive(record, "landmark", userAddressInfo.getLandmark());
        this.serializePrimitive(record, "city", userAddressInfo.getCity());
        this.serializePrimitive(record, "state", userAddressInfo.getState());
        this.serializePrimitive(record, "state_code", userAddressInfo.getState_code());
        this.serializePrimitive(record, "country", userAddressInfo.getCountry());
        this.serializePrimitive(record, "pincode", userAddressInfo.getPincode());
        this.serializePrimitive(record, "phone", userAddressInfo.getPhone());
        this.serializePrimitive(record, "guest", userAddressInfo.isGuest());
        this.serializePrimitive(record, "active", userAddressInfo.isActive());
        this.serializePrimitive(record, "version", userAddressInfo.getVersion());
        this.serializePrimitive(record, "creation_date", userAddressInfo.getCreation_date());
        this.serializePrimitive(record, "last_modified", userAddressInfo.getLast_modified());
        this.serializePrimitive(record, "creating_system", userAddressInfo.getCreating_system());
        if (userAddressInfo.getPreferences() != null) {
            HashMap<String, String> preferencesAsStringMap = new HashMap<String, String>();
            for (String key : userAddressInfo.getPreferences().keySet()) {
                try {
                    preferencesAsStringMap.put(key, this.objectMapper.writer().writeValueAsString(userAddressInfo.getPreferences().get(key)));
                }
                catch (Exception e) {
                    throw new SerializationFailedException("Serialization failed for userAddressInfo.getPreferences().get(key). Error is : " + e.getMessage(), (Throwable)e);
                }
            }
            this.serializeObject(record, "preferences", preferencesAsStringMap);
        }
    }

    public Collection<NFTypeSerializer<?>> requiredSubSerializers() {
        return this.serializers(new NFTypeSerializer[]{new MapSerializer("MapOfPreferences", (NFTypeSerializer)new StringSerializer(), (NFTypeSerializer)new StringSerializer())});
    }
}

