/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.serializer.serializers;

import com.flipkart.aesop.serializer.model.UserPreferencesInfo;
import com.netflix.zeno.fastblob.record.schema.FastBlobSchema;
import com.netflix.zeno.serializer.NFDeserializationRecord;
import com.netflix.zeno.serializer.NFSerializationRecord;
import com.netflix.zeno.serializer.NFTypeSerializer;
import com.netflix.zeno.serializer.common.MapSerializer;
import com.netflix.zeno.serializer.common.StringSerializer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.core.serializer.support.SerializationFailedException;

public class UserPreferencesInfoSerializer
extends NFTypeSerializer<UserPreferencesInfo> {
    private ObjectMapper objectMapper = new ObjectMapper();

    public UserPreferencesInfoSerializer() {
        super(UserPreferencesInfo.class.getName());
    }

    protected FastBlobSchema createSchema() {
        return this.schema(new NFTypeSerializer.FastBlobSchemaField[]{this.field("id", FastBlobSchema.FieldType.STRING), this.field("preferences_name", FastBlobSchema.FieldType.STRING), this.field("value", "MapOfValue"), this.field("version", FastBlobSchema.FieldType.INT), this.field("last_modified", FastBlobSchema.FieldType.STRING)});
    }

    protected UserPreferencesInfo doDeserialize(NFDeserializationRecord record) {
        String id = this.deserializePrimitiveString(record, "id");
        String preferences_name = this.deserializePrimitiveString(record, "preferences_name");
        Map valueAsStringMap = (Map)this.deserializeObject(record, "value");
        HashMap<String, Object> value = new HashMap<String, Object>();
        for (String key : valueAsStringMap.keySet()) {
            try {
                value.put(key, this.objectMapper.readValue((String)valueAsStringMap.get(key), Object.class));
            }
            catch (Exception e) {
                throw new SerializationFailedException("Serialization failed for userPreferencesInfo.getValue().get(key). Error is : " + e.getMessage(), (Throwable)e);
            }
        }
        int version = this.deserializeInteger(record, "version");
        String last_modified = this.deserializePrimitiveString(record, "last_modified");
        return new UserPreferencesInfo(id, preferences_name, value, version, last_modified);
    }

    public void doSerialize(UserPreferencesInfo userPreferencesInfo, NFSerializationRecord record) {
        this.serializePrimitive(record, "id", userPreferencesInfo.getId());
        this.serializePrimitive(record, "preferences_name", userPreferencesInfo.getPreferences_name());
        if (userPreferencesInfo.getValue() != null) {
            HashMap<String, String> valueAsStringMap = new HashMap<String, String>();
            for (String key : userPreferencesInfo.getValue().keySet()) {
                try {
                    valueAsStringMap.put(key, this.objectMapper.writer().writeValueAsString(userPreferencesInfo.getValue().get(key)));
                }
                catch (Exception e) {
                    throw new SerializationFailedException("Serialization failed for userPreferencesInfo.getValue().get(key). Error is : " + e.getMessage(), (Throwable)e);
                }
            }
            this.serializeObject(record, "value", valueAsStringMap);
        }
        this.serializePrimitive(record, "version", userPreferencesInfo.getVersion());
        this.serializePrimitive(record, "last_modified", userPreferencesInfo.getLast_modified());
    }

    public Collection<NFTypeSerializer<?>> requiredSubSerializers() {
        return this.serializers(new NFTypeSerializer[]{new MapSerializer("MapOfValue", (NFTypeSerializer)new StringSerializer(), (NFTypeSerializer)new StringSerializer())});
    }
}

