/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.serializer.serializers;

import com.flipkart.aesop.serializer.model.UserInfo;
import com.flipkart.aesop.serializer.serializers.UserAddressInfoSerializer;
import com.flipkart.aesop.serializer.serializers.UserPreferencesInfoSerializer;
import com.netflix.zeno.fastblob.record.schema.FastBlobSchema;
import com.netflix.zeno.serializer.NFDeserializationRecord;
import com.netflix.zeno.serializer.NFSerializationRecord;
import com.netflix.zeno.serializer.NFTypeSerializer;
import com.netflix.zeno.serializer.common.ListSerializer;
import com.netflix.zeno.serializer.common.MapSerializer;
import com.netflix.zeno.serializer.common.SetSerializer;
import com.netflix.zeno.serializer.common.StringSerializer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UserInfoSerializer
extends NFTypeSerializer<UserInfo> {
    public UserInfoSerializer() {
        super(UserInfo.class.getName());
    }

    protected FastBlobSchema createSchema() {
        return this.schema(new NFTypeSerializer.FastBlobSchemaField[]{this.field("id", FastBlobSchema.FieldType.STRING), this.field("primary_account_id", FastBlobSchema.FieldType.STRING), this.field("first_name", FastBlobSchema.FieldType.STRING), this.field("last_name", FastBlobSchema.FieldType.STRING), this.field("primary_email", FastBlobSchema.FieldType.STRING), this.field("primary_phone", FastBlobSchema.FieldType.STRING), this.field("profile_name", FastBlobSchema.FieldType.STRING), this.field("blacklisted_parent", FastBlobSchema.FieldType.STRING), this.field("status", FastBlobSchema.FieldType.STRING), this.field("active", FastBlobSchema.FieldType.BOOLEAN), this.field("guest", FastBlobSchema.FieldType.BOOLEAN), this.field("blacklisted", FastBlobSchema.FieldType.BOOLEAN), this.field("preferences", "MapOfPreferences"), this.field("addresses", "SetOfAddresses"), this.field("merged_account_ids", "MergedAccountIdsList"), this.field("version", FastBlobSchema.FieldType.INT), this.field("creation_date", FastBlobSchema.FieldType.STRING), this.field("last_modified", FastBlobSchema.FieldType.STRING), this.field("creating_system", FastBlobSchema.FieldType.STRING)});
    }

    protected UserInfo doDeserialize(NFDeserializationRecord record) {
        String id = this.deserializePrimitiveString(record, "id");
        String primary_account_id = this.deserializePrimitiveString(record, "primary_account_id");
        String first_name = this.deserializePrimitiveString(record, "first_name");
        String last_name = this.deserializePrimitiveString(record, "last_name");
        String primary_email = this.deserializePrimitiveString(record, "primary_email");
        String primary_phone = this.deserializePrimitiveString(record, "primary_phone");
        String profile_name = this.deserializePrimitiveString(record, "profile_name");
        String blacklisted_parent = this.deserializePrimitiveString(record, "blacklisted_parent");
        String status = this.deserializePrimitiveString(record, "status");
        boolean active = this.deserializeBoolean(record, "active");
        boolean guest = this.deserializeBoolean(record, "guest");
        boolean blacklisted = this.deserializeBoolean(record, "blacklisted");
        Map preferences = (Map)this.deserializeObject(record, "preferences");
        Set addresses = (Set)this.deserializeObject(record, "addresses");
        List merged_account_ids = (List)this.deserializeObject(record, "merged_account_ids");
        int version = this.deserializeInteger(record, "version");
        String creation_date = this.deserializePrimitiveString(record, "creation_date");
        String last_modified = this.deserializePrimitiveString(record, "last_modified");
        String creating_system = this.deserializePrimitiveString(record, "creating_system");
        return new UserInfo(id, primary_account_id, first_name, last_name, primary_email, primary_phone, profile_name, blacklisted_parent, status, active, guest, blacklisted, preferences, addresses, merged_account_ids, version, creation_date, last_modified, creating_system);
    }

    public void doSerialize(UserInfo userInfo, NFSerializationRecord record) {
        this.serializePrimitive(record, "id", userInfo.getId());
        this.serializePrimitive(record, "primary_account_id", userInfo.getPrimary_account_id());
        this.serializePrimitive(record, "first_name", userInfo.getFirst_name());
        this.serializePrimitive(record, "last_name", userInfo.getLast_name());
        this.serializePrimitive(record, "primary_email", userInfo.getPrimary_email());
        this.serializePrimitive(record, "primary_phone", userInfo.getPrimary_phone());
        this.serializePrimitive(record, "profile_name", userInfo.getProfile_name());
        this.serializePrimitive(record, "blacklisted_parent", userInfo.getBlacklisted_parent());
        this.serializePrimitive(record, "status", userInfo.getStatus());
        this.serializePrimitive(record, "active", userInfo.isActive());
        this.serializePrimitive(record, "guest", userInfo.isGuest());
        this.serializePrimitive(record, "blacklisted", userInfo.getBlacklisted());
        this.serializeObject(record, "preferences", userInfo.getPreferences());
        this.serializeObject(record, "addresses", userInfo.getAddresses());
        this.serializeObject(record, "merged_account_ids", userInfo.getMerged_account_ids());
        this.serializePrimitive(record, "version", userInfo.getVersion());
        this.serializePrimitive(record, "creation_date", userInfo.getCreation_date());
        this.serializePrimitive(record, "last_modified", userInfo.getLast_modified());
        this.serializePrimitive(record, "creating_system", userInfo.getCreating_system());
    }

    public Collection<NFTypeSerializer<?>> requiredSubSerializers() {
        return this.serializers(new NFTypeSerializer[]{new MapSerializer("MapOfPreferences", (NFTypeSerializer)new StringSerializer(), (NFTypeSerializer)new UserPreferencesInfoSerializer()), new SetSerializer("SetOfAddresses", (NFTypeSerializer)new UserAddressInfoSerializer()), new ListSerializer("MergedAccountIdsList", (NFTypeSerializer)new StringSerializer())});
    }
}

