/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.serializer.batch.reader;

import com.flipkart.aesop.serializer.batch.reader.ScanResult;
import com.flipkart.aesop.serializer.model.UserInfo;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ItemStreamReader;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.UnexpectedInputException;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class UserInfoServiceScanReader<T extends UserInfo>
implements ItemStreamReader<UserInfo> {
    private static final Logger LOGGER = LogFactory.getLogger(UserInfoServiceScanReader.class);
    private static final int MAX_RESULTS = 10000;
    private static final String BATCH_SERVICE_URL = "http://localhost:25151/userservice/v0.1/customer/batch";
    private static final int BATCH_SIZE = 500;
    private ObjectMapper objectMapper = new ObjectMapper();
    private int resultCount = -500;
    private Semaphore parallelFetch = new Semaphore(5);
    private Queue<UserInfo> localQueue = new ConcurrentLinkedQueue<UserInfo>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserInfo read() throws Exception, UnexpectedInputException, ParseException {
        UserInfoServiceScanReader userInfoServiceScanReader = this;
        synchronized (userInfoServiceScanReader) {
            if (!this.localQueue.isEmpty()) {
                LOGGER.debug("Returning data from local cache. Cache size : " + this.localQueue.size());
                return this.localQueue.poll();
            }
        }
        this.parallelFetch.acquire();
        int startIndex = 0;
        UserInfoServiceScanReader userInfoServiceScanReader2 = this;
        synchronized (userInfoServiceScanReader2) {
            startIndex = this.resultCount += 500;
        }
        if (this.resultCount < 10000) {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpGet executionGet = new HttpGet(BATCH_SERVICE_URL);
            URIBuilder uriBuilder = new URIBuilder(executionGet.getURI());
            uriBuilder.addParameter("start", String.valueOf(startIndex));
            uriBuilder.addParameter("count", String.valueOf(500));
            executionGet.setURI(uriBuilder.build());
            HttpResponse httpResponse = httpclient.execute((HttpUriRequest)executionGet);
            String response = new String(EntityUtils.toByteArray((HttpEntity)httpResponse.getEntity()));
            ScanResult scanResult = (ScanResult)this.objectMapper.readValue(response, ScanResult.class);
            if (scanResult.getCount() <= 0) {
                this.parallelFetch.release();
                return null;
            }
            LOGGER.info("Fetched User Info objects in range - Start : {}. Count : {}", (Object)startIndex, (Object)scanResult.getCount());
            for (UserInfo userInfo : scanResult.getResponse()) {
                this.localQueue.add(userInfo);
            }
        }
        this.parallelFetch.release();
        return this.localQueue.poll();
    }

    public void open(ExecutionContext context) throws ItemStreamException {
        this.resultCount = -500;
    }

    public void update(ExecutionContext context) throws ItemStreamException {
    }

    public void close() throws ItemStreamException {
    }
}

