/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.aesop.serializer.batch.reader;

import com.flipkart.aesop.serializer.batch.reader.SearchResult;
import com.flipkart.aesop.serializer.model.UserInfo;
import com.flipkart.aesop.serializer.model.UserPreferencesInfo;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.UnexpectedInputException;
import org.trpr.platform.batch.common.BatchException;
import org.trpr.platform.batch.spi.spring.reader.BatchItemStreamReader;

public class UserInfoServiceReader<T extends UserInfo>
implements BatchItemStreamReader<UserInfo> {
    private static final String SERVICE_URL = "http://localhost/userservice/v0.1/customer";
    private ObjectMapper objectMapper = new ObjectMapper();
    private static final String[] PHONE_NUMBERS = new String[]{"6543217890", "6543217891", "9090912345", "9586545778", "9632828337", "9740417580", "9845452123", "9876543210", "9898989898", "9933551100"};
    private boolean hasRun;
    private int modIndex = PHONE_NUMBERS.length - 1;
    private UserInfo[] results = new UserInfo[PHONE_NUMBERS.length];

    public UserInfo[] batchRead(ExecutionContext context) throws Exception, UnexpectedInputException, ParseException {
        if (!this.hasRun) {
            this.objectMapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            int i = 0;
            while (i < PHONE_NUMBERS.length) {
                DefaultHttpClient httpclient = new DefaultHttpClient();
                HttpGet executionGet = new HttpGet(SERVICE_URL);
                URIBuilder uriBuilder = new URIBuilder(executionGet.getURI());
                uriBuilder.addParameter("primary_phone", PHONE_NUMBERS[i]);
                uriBuilder.addParameter("require", "{\"preferences\":true,\"addresses\":true}");
                executionGet.setURI(uriBuilder.build());
                HttpResponse httpResponse = httpclient.execute((HttpUriRequest)executionGet);
                String response = new String(EntityUtils.toByteArray((HttpEntity)httpResponse.getEntity()));
                SearchResult searchResult = (SearchResult)this.objectMapper.readValue(response, SearchResult.class);
                this.results[i] = searchResult.results[0];
                ++i;
            }
            this.hasRun = true;
        } else {
            if (this.modIndex < 0) {
                return null;
            }
            System.out.println("Modifiying response object at index : " + this.modIndex);
            this.results[this.modIndex].setFirst_name("Regu " + this.modIndex);
            this.results[this.modIndex].setLast_name("B " + this.modIndex);
            this.results[this.modIndex].setPrimary_email("regunathb@gmail.com" + this.modIndex);
            this.results[this.modIndex].setPrimary_phone("9886693892" + this.modIndex);
            if (this.results[this.modIndex].getPreferences() != null && this.results[this.modIndex].getPreferences().size() > 0) {
                for (String key : this.results[this.modIndex].getPreferences().keySet()) {
                    UserPreferencesInfo upi = this.results[this.modIndex].getPreferences().get(key);
                    HashMap<String, Object> values = new HashMap<String, Object>();
                    values.put("communication", "email");
                    values.put("address", "home");
                    upi.setValue(values);
                }
            }
            --this.modIndex;
        }
        return this.results;
    }

    public UserInfo read() throws Exception, UnexpectedInputException, ParseException {
        throw new BatchException("Operation is not supported! Use the CompositeItemStreamReader#read() method instead.");
    }

    public void open(ExecutionContext context) throws ItemStreamException {
    }

    public void update(ExecutionContext context) throws ItemStreamException {
    }

    public void close() throws ItemStreamException {
    }
}

