/*
 * Decompiled with CFR 0.152.
 */
package flipkart.cp.convert.chronosQ.client;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import flipkart.cp.convert.chronosQ.core.Partitioner;
import flipkart.cp.convert.chronosQ.core.SchedulerEntry;
import flipkart.cp.convert.chronosQ.core.SchedulerStore;
import flipkart.cp.convert.chronosQ.core.TimeBucket;
import flipkart.cp.convert.chronosQ.exceptions.ErrorCode;
import flipkart.cp.convert.chronosQ.exceptions.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerClient<Entry extends SchedulerEntry> {
    private final SchedulerStore store;
    private final TimeBucket timeBucket;
    private final Partitioner partitioner;
    private final long DATASTORE_NO_OPERATION = 0L;
    private final MetricRegistry metricRegistry;
    private Timer addTimeTaken;
    private Timer removeTimeTaken;
    private Timer updateTimeTaken;
    private static Logger log = LoggerFactory.getLogger((String)SchedulerClient.class.getName());

    public SchedulerClient(SchedulerStore store, TimeBucket timeBucket, Partitioner partitioner, MetricRegistry metricRegistry) {
        this.store = store;
        this.timeBucket = timeBucket;
        this.partitioner = partitioner;
        this.metricRegistry = metricRegistry;
    }

    public void add(Entry schedulerEntry, long time) throws SchedulerException {
        String val = schedulerEntry.getKey();
        int partitionNumber = this.partitioner.getPartition(val);
        Timer.Context context = null;
        if (this.metricRegistry != null) {
            this.addTimeTaken = this.metricRegistry.timer("scheduler.SchedulerClient.AddRequests.partition_" + partitionNumber);
            context = this.addTimeTaken.time();
        }
        try {
            this.store.add(schedulerEntry, this.timeBucket.toBucket(time), partitionNumber);
            log.info("Add :" + val + "-" + time);
        }
        catch (Exception ex) {
            log.error("Unable to add to scheduler  :" + val + "-" + time + ex.fillInStackTrace());
            throw new SchedulerException((Throwable)ex, ErrorCode.DATASTORE_READWRITE_ERROR);
        }
        finally {
            if (context != null) {
                context.stop();
            }
        }
    }

    public boolean update(Entry schedulerEntry, long oldTime, long newTime) throws SchedulerException {
        String val = schedulerEntry.getKey();
        boolean result = false;
        int partitionNumber = this.partitioner.getPartition(val);
        Timer.Context context = null;
        if (this.metricRegistry != null) {
            this.updateTimeTaken = this.metricRegistry.timer("scheduler.SchedulerClient.UpdateRequests.partition_" + partitionNumber);
            context = this.updateTimeTaken.time();
        }
        try {
            Long storeResult = this.store.update(schedulerEntry, this.timeBucket.toBucket(oldTime), this.timeBucket.toBucket(newTime), partitionNumber);
            if (storeResult != 0L) {
                result = true;
            }
            log.info("Updated :" + val + "-From " + oldTime + " To" + newTime);
            boolean bl = result;
            return bl;
        }
        catch (Exception ex) {
            log.error("Unable to update value :" + val + "-From " + oldTime + " To" + newTime + ex.fillInStackTrace());
            throw new SchedulerException((Throwable)ex, ErrorCode.DATASTORE_READWRITE_ERROR);
        }
        finally {
            if (context != null) {
                context.stop();
            }
        }
    }

    public boolean remove(Entry schedulerEntry, long time) throws SchedulerException {
        String val = schedulerEntry.getKey();
        boolean result = false;
        int partitionNumber = this.partitioner.getPartition(val);
        Timer.Context context = null;
        if (this.metricRegistry != null) {
            this.removeTimeTaken = this.metricRegistry.timer("scheduler.SchedulerClient.RemoveRequests.partition_" + partitionNumber);
            context = this.removeTimeTaken.time();
        }
        try {
            Long storeResult = this.store.remove(val, this.timeBucket.toBucket(time), partitionNumber);
            if (storeResult != 0L) {
                result = true;
            }
            log.info("Removed:" + val + "-" + time);
            boolean bl = result;
            return bl;
        }
        catch (Exception ex) {
            log.error("Unable to remove from scheduler :" + val + "-" + time + ex.fillInStackTrace());
            throw new SchedulerException((Throwable)ex, ErrorCode.DATASTORE_READWRITE_ERROR);
        }
        finally {
            if (context != null) {
                context.stop();
            }
        }
    }

    public static <Entry extends SchedulerEntry> Builder<Entry> builder() {
        return new Builder();
    }

    public static class Builder<Entry extends SchedulerEntry> {
        private SchedulerStore store;
        private TimeBucket timeBucket;
        private Partitioner partitioner;
        private MetricRegistry metricRegistry = null;
        private SchedulerClient<Entry> _client = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SchedulerClient<Entry> buildOrGet() {
            if (this._client == null) {
                Builder builder = this;
                synchronized (builder) {
                    if (this._client == null) {
                        this._client = new SchedulerClient(this.store, this.timeBucket, this.partitioner, this.metricRegistry);
                    }
                }
            }
            return this._client;
        }

        public Builder<Entry> withStore(SchedulerStore store) {
            this.store = store;
            return this;
        }

        public Builder<Entry> withTimeBucket(TimeBucket timeBucket) {
            this.timeBucket = timeBucket;
            return this;
        }

        public Builder<Entry> withPartitioner(Partitioner partitioner) {
            this.partitioner = partitioner;
            return this;
        }

        public Builder<Entry> withMetricRegistry(MetricRegistry metricRegistry) {
            this.metricRegistry = metricRegistry;
            return this;
        }
    }
}

