/*
 * Decompiled with CFR 0.152.
 */
package flipkart.cp.convert.chronosQ.impl.hbase;

import flipkart.cp.convert.chronosQ.core.SchedulerCheckpointer;
import flipkart.cp.convert.chronosQ.exceptions.ErrorCode;
import flipkart.cp.convert.chronosQ.exceptions.SchedulerException;
import flipkart.cp.convert.chronosQ.impl.hbase.HbaseUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HbaseSchedulerCheckpoint
implements SchedulerCheckpointer {
    static Logger log = LoggerFactory.getLogger((String)HbaseSchedulerCheckpoint.class.getSimpleName());
    static final String DELIMITER = "__";
    static final byte[] QUALIFIER = Bytes.toBytes((String)"val");
    final Connection hConnection;
    final String tableName;
    final byte[] columnFamily;
    final String instanceName;

    public HbaseSchedulerCheckpoint(Connection hConnection, String tableName, String columnFamily, String instanceName) {
        this.hConnection = hConnection;
        this.tableName = tableName;
        this.columnFamily = Bytes.toBytes((String)columnFamily);
        this.instanceName = instanceName;
    }

    public String peek(int partitionNum) throws SchedulerException {
        String timerKey = this.getTimerKey(partitionNum);
        Table hTable = null;
        try {
            hTable = this.getHTable();
            Result result = hTable.get(HbaseUtils.createGet(timerKey, this.columnFamily));
            NavigableMap fMap = result.getFamilyMap(this.columnFamily);
            String value = new String((byte[])fMap.get(QUALIFIER));
            log.info("Fetching value for key " + timerKey + "is-" + value);
            String string = value;
            return string;
        }
        catch (Exception ex) {
            log.error("Exception occurred for " + timerKey + ex.fillInStackTrace());
            throw new SchedulerException((Throwable)ex, ErrorCode.DATASTORE_CHECKPOINT_ERROR);
        }
        finally {
            this.releaseHTableInterface(hTable);
        }
    }

    public void set(String value, int partitionNum) throws SchedulerException {
        String timerKey = this.getTimerKey(partitionNum);
        HashMap<byte[], byte[]> data = new HashMap<byte[], byte[]>();
        data.put(QUALIFIER, Bytes.toBytes((String)value));
        Table hTable = null;
        try {
            hTable = this.getHTable();
            hTable.put(HbaseUtils.createPut(timerKey, this.columnFamily, data));
            log.info("Setting value to key " + timerKey + " to-" + value);
        }
        catch (Exception ex) {
            log.error("Exception occurred for " + timerKey + "-" + value + ex.fillInStackTrace());
            throw new SchedulerException((Throwable)ex, ErrorCode.DATASTORE_CHECKPOINT_ERROR);
        }
        finally {
            this.releaseHTableInterface(hTable);
        }
    }

    private Table getHTable() throws IOException {
        return this.hConnection.getTable(TableName.valueOf((String)this.tableName));
    }

    private void releaseHTableInterface(Table hTable) throws SchedulerException {
        try {
            if (null != hTable) {
                hTable.close();
            }
        }
        catch (IOException e) {
            log.error("Exception occurred While closing hTable - " + this.tableName + "-" + e.fillInStackTrace());
            throw new SchedulerException((Throwable)e, ErrorCode.DATASTORE_CHECKPOINT_ERROR);
        }
    }

    private String getTimerKey(int partitionNum) {
        return this.instanceName + DELIMITER + Integer.toString(partitionNum);
    }
}

