/*
 * Decompiled with CFR 0.152.
 */
package flipkart.cp.convert.chronosQ.impl.kafka;

import flipkart.cp.convert.chronosQ.core.DefaultSchedulerEntry;
import flipkart.cp.convert.chronosQ.core.SchedulerEntry;
import flipkart.cp.convert.chronosQ.exceptions.SchedulerException;
import flipkart.cp.convert.chronosQ.impl.kafka.KafkaMessage;
import flipkart.cp.convert.chronosQ.impl.kafka.KafkaSchedulerSink;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.kafka.clients.producer.ProducerRecord;

public class KafkaSchedulerSinkExample {
    public static void main(String[] args) throws SchedulerException {
        Properties props = new Properties();
        props.put("metadata.broker.list", "tgstage-bro-app-0002.ch.flipkart.com:9092");
        props.put("producer.type", "sync");
        props.put("serializer.class", "kafka.serializer.StringEncoder");
        KafkaSchedulerSink kafkaSchedulerSink = new KafkaSchedulerSink(props, "test_scheduler_002", new KafkaMessage(){

            @Override
            public ProducerRecord<byte[], byte[]> getKeyedMessage(String topic, SchedulerEntry schedulerEntry) {
                return new ProducerRecord(topic, (Object)schedulerEntry.getKey().getBytes(), (Object)schedulerEntry.getPayload().getBytes());
            }
        });
        ArrayList<SchedulerEntry> values = new ArrayList<SchedulerEntry>();
        values.add((SchedulerEntry)new DefaultSchedulerEntry("entry1", "entry1"));
        values.add((SchedulerEntry)new DefaultSchedulerEntry("entry2", "entry2"));
        kafkaSchedulerSink.giveExpiredListForProcessing(values);
        kafkaSchedulerSink.giveExpiredForProcessing((SchedulerEntry)new DefaultSchedulerEntry("entry3", "entry3"));
        kafkaSchedulerSink.giveExpiredListForProcessing(values);
        kafkaSchedulerSink.giveExpiredForProcessing((SchedulerEntry)new DefaultSchedulerEntry("entry4", "entry4"));
    }
}

