/*
 * Decompiled with CFR 0.152.
 */
package flipkart.cp.convert.chronosQ.impl.redis;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.util.Pool;

public class RedisParitioner {
    private final List<Pool<Jedis>> poolList;
    private final int numOfConnections;

    public void addInstance(JedisShardInfo config) {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxTotal(this.numOfConnections);
        JedisPool jedisPool = new JedisPool((GenericObjectPoolConfig)poolConfig, config.getHost(), config.getPort());
        this.poolList.add((Pool<Jedis>)jedisPool);
    }

    public void addInstance(Pool<Jedis> pool) {
        this.poolList.add(pool);
    }

    public RedisParitioner(int numOfConnections) {
        this.numOfConnections = numOfConnections;
        this.poolList = new ArrayList<Pool<Jedis>>();
    }

    public RedisParitioner(List<Pool<Jedis>> poolList, int numOfConnections) {
        this.poolList = poolList;
        this.numOfConnections = numOfConnections;
    }

    public RedisParitioner(List<Pool<Jedis>> poolList) {
        this.poolList = poolList;
        this.numOfConnections = 0;
    }

    public Pool<Jedis> getJedis(int partitionNum) {
        int hashed = partitionNum % this.poolList.size();
        return this.poolList.get(hashed);
    }
}

