/*
 * Decompiled with CFR 0.152.
 */
package flipkart.cp.convert.chronosQ.impl.redis;

import flipkart.cp.convert.chronosQ.core.SchedulerCheckpointer;
import flipkart.cp.convert.chronosQ.exceptions.ErrorCode;
import flipkart.cp.convert.chronosQ.exceptions.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.util.Pool;

public class RedisSchedulerCheckpoint
implements SchedulerCheckpointer {
    private final String timerKeyPrefix;
    static Logger log = LoggerFactory.getLogger((String)RedisSchedulerCheckpoint.class.getName());
    private final Pool<Jedis> pool;

    public RedisSchedulerCheckpoint(Pool<Jedis> pool, String timerKeyPrefix) {
        this.pool = pool;
        this.timerKeyPrefix = timerKeyPrefix;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String peek(int partitionNum) throws SchedulerException {
        String key = RedisSchedulerCheckpoint._key(this.timerKeyPrefix, partitionNum);
        try (Jedis jedis = (Jedis)this.pool.getResource();){
            String value = jedis.get(key);
            log.info("Fetching value for key " + key + "is" + value);
            String string = value;
            return string;
        }
        catch (Exception ex) {
            log.error("Exception occurred for " + key + ex.getMessage());
            throw new SchedulerException((Throwable)ex, ErrorCode.DATASTORE_CHECKPOINT_ERROR);
        }
    }

    private static String _key(String timerKeyPrefix, int partitionNum) {
        return timerKeyPrefix + "-" + partitionNum;
    }

    public void set(String value, int partitionNum) throws SchedulerException {
        String key = RedisSchedulerCheckpoint._key(this.timerKeyPrefix, partitionNum);
        try (Jedis jedis = (Jedis)this.pool.getResource();){
            jedis.set(key, value);
            log.info("Setting value to key " + key + " to-" + value);
        }
        catch (Exception ex) {
            log.error("Exception occurred for " + key + "-" + value + ex.getMessage());
            throw new SchedulerException((Throwable)ex, ErrorCode.DATASTORE_CHECKPOINT_ERROR);
        }
    }
}

