/*
 * Decompiled with CFR 0.152.
 */
package flipkart.cp.convert.chronosQ.impl.redis;

import flipkart.cp.convert.chronosQ.core.DefaultSchedulerEntry;
import flipkart.cp.convert.chronosQ.core.SchedulerEntry;
import flipkart.cp.convert.chronosQ.core.SchedulerStore;
import flipkart.cp.convert.chronosQ.exceptions.ErrorCode;
import flipkart.cp.convert.chronosQ.exceptions.SchedulerException;
import flipkart.cp.convert.chronosQ.impl.redis.RedisParitioner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.util.Pool;

public class RedisSchedulerStore
implements SchedulerStore {
    private static final Logger log = LoggerFactory.getLogger(RedisSchedulerStore.class);
    private final RedisParitioner redisParitioner;
    private static final String DELIMITER = "-";
    private final String keyPrefix;

    public RedisSchedulerStore(RedisParitioner redisParitioner) {
        this(redisParitioner, "");
    }

    public RedisSchedulerStore(RedisParitioner redisParitioner, String keyPrefix) {
        this.redisParitioner = redisParitioner;
        this.keyPrefix = keyPrefix;
    }

    private Jedis _getInstance(int partitionNum) throws SchedulerException {
        try {
            Pool<Jedis> jedisPool = this.redisParitioner.getJedis(partitionNum);
            return (Jedis)jedisPool.getResource();
        }
        catch (Exception e) {
            throw new SchedulerException((Throwable)e, ErrorCode.DATASTORE_READWRITE_ERROR);
        }
    }

    public void add(SchedulerEntry schedulerEntry, long time, int partitionNum) throws SchedulerException {
        String key = "";
        try (Jedis jedis = this._getInstance(partitionNum);){
            key = this.getKey(time, partitionNum);
            jedis.sadd(key, new String[]{schedulerEntry.getKey()});
            jedis.set(this.getPayloadKey(schedulerEntry.getKey()), schedulerEntry.getPayload());
            log.info("Added value " + schedulerEntry.getKey() + "To " + key);
        }
        catch (Exception ex) {
            log.error("Exception occurred  for -" + schedulerEntry.getKey() + "Key" + key + "Partition " + partitionNum + DELIMITER + ex.getMessage());
            throw new SchedulerException((Throwable)ex, ErrorCode.DATASTORE_READWRITE_ERROR);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long update(SchedulerEntry schedulerEntry, long oldTime, long newTime, int partitionNum) throws SchedulerException {
        String oldKey = "";
        String newKey = "";
        try (Jedis jedis = this._getInstance(partitionNum);){
            oldKey = this.getKey(oldTime, partitionNum);
            newKey = this.getKey(newTime, partitionNum);
            Long result = jedis.smove(oldKey, newKey, schedulerEntry.getKey());
            log.info("Updated value " + schedulerEntry.getKey() + "From " + oldKey + "To " + newKey);
            Long l = result;
            return l;
        }
        catch (Exception ex) {
            log.error("Exception occurred  for -" + schedulerEntry.getKey() + "Key" + oldKey + "Partition " + partitionNum + DELIMITER + ex.getMessage());
            throw new SchedulerException((Throwable)ex, ErrorCode.DATASTORE_READWRITE_ERROR);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long remove(String value, long time, int partitionNum) throws SchedulerException {
        String key = "";
        try (Jedis jedis = this._getInstance(partitionNum);){
            key = this.getKey(time, partitionNum);
            Long result = jedis.srem(key, new String[]{value});
            jedis.del(this.getPayloadKey(value));
            log.info("Removed value " + value + "From" + key);
            Long l = result;
            return l;
        }
        catch (Exception ex) {
            log.error("Exception occurred  for -" + value + "Key" + key + "Partition " + partitionNum + DELIMITER + ex.getMessage());
            throw new SchedulerException((Throwable)ex, ErrorCode.DATASTORE_READWRITE_ERROR);
        }
    }

    public List<SchedulerEntry> get(long time, int partitionNum) throws SchedulerException {
        List<SchedulerEntry> schedulerDataList;
        String key = "";
        try (Jedis jedis = this._getInstance(partitionNum);){
            key = this.getKey(time, partitionNum);
            Set resultSet = jedis.smembers(key);
            log.info("Get For " + key + DELIMITER + resultSet);
            schedulerDataList = this.getSchedulerPayloadValues(partitionNum, resultSet);
        }
        catch (Exception ex) {
            log.error("Exception occurred  for -Key" + key + "Partition " + partitionNum + DELIMITER + ex.getMessage());
            throw new SchedulerException((Throwable)ex, ErrorCode.DATASTORE_READWRITE_ERROR);
        }
        return schedulerDataList;
    }

    public List<SchedulerEntry> getNextN(long time, int partitionNum, int n) throws SchedulerException {
        List<SchedulerEntry> schedulerDataList;
        String key = "";
        try (Jedis jedis = this._getInstance(partitionNum);){
            key = this.getKey(time, partitionNum);
            List resultSet = jedis.srandmember(key, n);
            log.info("Get For " + key + DELIMITER + resultSet);
            schedulerDataList = this.getSchedulerPayloadValues(partitionNum, resultSet);
        }
        catch (Exception ex) {
            log.error("Exception occurred  for -Key" + key + "Partition " + partitionNum + DELIMITER + ex.getMessage());
            throw new SchedulerException((Throwable)ex, ErrorCode.DATASTORE_READWRITE_ERROR);
        }
        return schedulerDataList;
    }

    private List<SchedulerEntry> getSchedulerPayloadValues(int partitionNum, Collection<String> resultSet) throws SchedulerException {
        ArrayList<SchedulerEntry> schedulerDataList = new ArrayList<SchedulerEntry>();
        if (resultSet.isEmpty()) {
            return schedulerDataList;
        }
        try (Jedis jedis = this._getInstance(partitionNum);){
            HashSet<String> keySet = new HashSet<String>(resultSet);
            String[] keys = (String[])keySet.stream().map(this::getPayloadKey).toArray(String[]::new);
            List schedulerValues = jedis.mget(keys);
            Iterator keyIterator = keySet.iterator();
            Iterator valueIterator = schedulerValues.iterator();
            while (keyIterator.hasNext() && valueIterator.hasNext()) {
                String key = (String)keyIterator.next();
                String value = Optional.ofNullable(valueIterator.next()).orElse(key);
                schedulerDataList.add((SchedulerEntry)new DefaultSchedulerEntry(key, value));
            }
        }
        catch (Exception ex) {
            log.error("Exception occurred  for -mget payload for Partition " + partitionNum + DELIMITER + ex.getMessage());
            throw new SchedulerException((Throwable)ex, ErrorCode.DATASTORE_READWRITE_ERROR);
        }
        return schedulerDataList;
    }

    public void removeBulk(long time, int partitionNum, List<String> values) throws SchedulerException {
        String key = "";
        try (Jedis jedis = this._getInstance(partitionNum);){
            Pipeline pipeline = jedis.pipelined();
            key = this.getKey(time, partitionNum);
            for (String value : values) {
                pipeline.srem(key, new String[]{value});
                pipeline.del(this.getPayloadKey(value));
            }
            log.info("Removed values " + values + "From" + key);
        }
        catch (Exception ex) {
            log.error("Exception occurred  for -" + values + "Key" + key + "Partition " + partitionNum + DELIMITER + ex.getMessage());
            throw new SchedulerException((Throwable)ex, ErrorCode.DATASTORE_READWRITE_ERROR);
        }
    }

    private String getKey(long time, int partitionNum) {
        String prefix = this.keyPrefix != null && !this.keyPrefix.equals("") ? this.keyPrefix + DELIMITER : "";
        return prefix + RedisSchedulerStore.convertNumToString(time) + DELIMITER + RedisSchedulerStore.convertNumToString(partitionNum);
    }

    private String getPayloadKey(String rawKey) {
        String prefix = this.keyPrefix != null && !this.keyPrefix.equals("") ? this.keyPrefix + DELIMITER : "";
        return prefix + rawKey;
    }

    private static String convertNumToString(long time) {
        return String.valueOf(time);
    }
}

