/*
 * Decompiled with CFR 0.152.
 */
package flipkart.cp.convert.ha.worker.distribution;

import com.google.common.annotations.VisibleForTesting;
import flipkart.cp.convert.ha.worker.distribution.DistributionManager;
import flipkart.cp.convert.ha.worker.distribution.Restartable;
import flipkart.cp.convert.ha.worker.exception.WorkerException;
import flipkart.cp.convert.ha.worker.task.StoppableTask;
import flipkart.cp.convert.ha.worker.task.WorkerTaskFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerManager
implements Restartable {
    private final WorkerTaskFactory workerTaskFactory;
    private final DistributionManager distributionManager;
    @VisibleForTesting
    private ExecutorService executorService;
    private List<StoppableTask> taskList;
    static Logger log = LoggerFactory.getLogger((String)WorkerManager.class.getName());

    public WorkerManager(WorkerTaskFactory workerTaskFactory, DistributionManager distributionManager) {
        this.workerTaskFactory = workerTaskFactory;
        this.distributionManager = distributionManager;
        this.distributionManager.setRestartable(this);
    }

    public synchronized void start() throws WorkerException {
        this.distributionManager.init();
        if (this.distributionManager.getTaskCount() > 0) {
            this.executorService = Executors.newFixedThreadPool(this.distributionManager.getTaskCount());
            List<String> taskIds = this.distributionManager.getTasksToRun();
            this.taskList = new ArrayList<StoppableTask>();
            log.info("Task ids " + taskIds);
            for (String taskId : taskIds) {
                log.info("Starting Thread for " + taskId);
                StoppableTask task = this.workerTaskFactory.getTask(taskId);
                this.executorService.submit(task);
                this.taskList.add(task);
            }
        }
    }

    private synchronized void _stopExecutorsIdempotent() {
        if (this.executorService != null && !this.executorService.isShutdown()) {
            log.info("Shutting down at " + new Date());
            for (StoppableTask task : this.taskList) {
                try {
                    task.stopGraceFully();
                }
                catch (WorkerException ex) {
                    task.stopPoisonPill();
                }
            }
            this.executorService.shutdownNow();
        }
    }

    public void stop() {
        this._stopExecutorsIdempotent();
    }

    @Override
    public void restart() throws WorkerException {
        log.info("Restarting scheduler worker ");
        this.stop();
        this.start();
    }
}

