/*
 * Decompiled with CFR 0.152.
 */
package flipkart.cp.convert.ha.worker;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import flipkart.cp.convert.ha.worker.di.WorkerModule;
import flipkart.cp.convert.ha.worker.distribution.DistributionManager;
import flipkart.cp.convert.ha.worker.distribution.WorkerManager;
import flipkart.cp.convert.ha.worker.exception.ErrorCode;
import flipkart.cp.convert.ha.worker.exception.WorkerException;
import flipkart.cp.convert.ha.worker.task.TaskList;
import flipkart.cp.convert.ha.worker.task.WorkerTaskFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.curator.framework.CuratorFramework;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bootstrap {
    private static String DEFAULT_NAMESPACE = "flipkart";
    private static Logger log = LoggerFactory.getLogger((String)Bootstrap.class.getName());
    private final Lock lock = new ReentrantLock();
    private final String instanceId;
    private final String nameSpace;
    private final String hostName;
    private String listenerPathSuffix = "";
    Reflections reflections;
    private static Options opts;

    public Bootstrap(String instanceId, String nameSpace, String hostName) {
        this.instanceId = instanceId;
        this.nameSpace = nameSpace;
        this.hostName = hostName;
    }

    public void start() throws WorkerException {
        List<AbstractModule> moduleList = this._getGuiceModules(this.hostName);
        ArrayList<WorkerManager> workerManagerList = new ArrayList<WorkerManager>();
        for (AbstractModule module : moduleList) {
            WorkerModule annotation = module.getClass().getAnnotation(WorkerModule.class);
            try {
                workerManagerList.add(this.startApp(annotation.appName(), Guice.createInjector((Module[])new Module[]{module})));
            }
            catch (WorkerException e) {
                throw new WorkerException(e, ErrorCode.WORKER_RUNTIME_ERROR);
            }
        }
        System.out.println("Worker has been started");
        Runtime.getRuntime().addShutdownHook(new ShutdownThread(workerManagerList));
        this.awaitShutdown();
    }

    private List<AbstractModule> _getGuiceModules(String hostName) {
        ArrayList<AbstractModule> moduleList = new ArrayList<AbstractModule>();
        this.reflections = new Reflections(this.nameSpace != null ? this.nameSpace : DEFAULT_NAMESPACE, new Scanner[0]);
        Set allGuiceModules = this.reflections.getSubTypesOf(AbstractModule.class);
        WorkerModuleFilter currentAppModuleFilter = new WorkerModuleFilter();
        for (Class module : allGuiceModules) {
            if (null == currentAppModuleFilter.apply(module)) continue;
            try {
                Class[] cArg = new Class[]{String.class};
                Constructor moduleWithArgs = module.getDeclaredConstructor(cArg);
                moduleList.add((AbstractModule)moduleWithArgs.newInstance(hostName));
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Unable to instantiate guice module :" + module, e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Unable to access guice module constructor:" + module, e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Unable to access guice module constructor:" + module, e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Unable to access guice module constructor:" + module, e);
            }
        }
        if (!moduleList.isEmpty()) {
            return moduleList;
        }
        throw new RuntimeException("Top level app module is not provided. Annotate with WorkerModule & give appropriate name");
    }

    public static void main(String[] args) throws WorkerException {
        GnuParser parser = new GnuParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(opts, args);
        }
        catch (ParseException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        String instanceId = cmd.getOptionValue('i');
        String hostName = cmd.getOptionValue('h');
        String nameSpace = cmd.getOptionValue('n');
        new Bootstrap(instanceId, nameSpace, hostName).start();
    }

    private WorkerManager startApp(String appName, Injector injector) throws WorkerException {
        CuratorFramework client = (CuratorFramework)injector.getInstance(CuratorFramework.class);
        WorkerTaskFactory taskFactory = (WorkerTaskFactory)injector.getInstance(WorkerTaskFactory.class);
        TaskList taskList = (TaskList)injector.getInstance(TaskList.class);
        MetricRegistry metricRegistry = (MetricRegistry)injector.getInstance(MetricRegistry.class);
        String listenerPath = this.buildListenerPath(appName);
        try {
            DistributionManager distributionManager = new DistributionManager(client, taskList, listenerPath, this.instanceId, metricRegistry);
            WorkerManager workerManager = new WorkerManager(taskFactory, distributionManager);
            workerManager.start();
            return workerManager;
        }
        catch (Exception ex) {
            log.error("Exception occurred " + ex.fillInStackTrace());
            throw new WorkerException(ex, ErrorCode.WORKER_RUNTIME_ERROR);
        }
    }

    private String buildListenerPath(String appName) {
        String listenerPath = appName;
        if (!Strings.isNullOrEmpty((String)this.listenerPathSuffix)) {
            listenerPath = listenerPath + "-" + this.listenerPathSuffix;
        }
        return listenerPath;
    }

    private void awaitShutdown() {
        this.lock.lock();
        this.lock.newCondition().awaitUninterruptibly();
    }

    public void setListenerPathSuffix(String listenerPathSuffix) {
        this.listenerPathSuffix = listenerPathSuffix;
    }

    static {
        Options options = new Options();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.withLongOpt((String)"instance-id");
        OptionBuilder.withDescription((String)"Instance Id - has to be unique for every instance of jvm (even on single box)");
        Options options2 = options.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.withLongOpt((String)"namespace");
        OptionBuilder.withDescription((String)"Namespace - to use to search for workerModule");
        Options options3 = options2.addOption(OptionBuilder.create((char)'n'));
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.withLongOpt((String)"host-name");
        OptionBuilder.withDescription((String)"Host Name");
        opts = options3.addOption(OptionBuilder.create((char)'h'));
    }

    private static class WorkerModuleFilter
    implements Function<Class<? extends AbstractModule>, Class<? extends AbstractModule>> {
        private WorkerModuleFilter() {
        }

        public Class<? extends AbstractModule> apply(Class<? extends AbstractModule> aClass) {
            if (aClass == null) {
                return null;
            }
            WorkerModule annotation = aClass.getAnnotation(WorkerModule.class);
            if (null == annotation) {
                return null;
            }
            return aClass;
        }
    }

    private static class ShutdownThread
    extends Thread {
        private final List<WorkerManager> workerManagerList;

        public ShutdownThread(List<WorkerManager> workerManagerList) {
            this.workerManagerList = workerManagerList;
        }

        @Override
        public void run() {
            for (WorkerManager workerManager : this.workerManagerList) {
                workerManager.stop();
            }
        }
    }
}

