/*
 * Decompiled with CFR 0.152.
 */
package org.dkv.client;

public class ConnectionOptions {
    private static final String DEF_METRIC_PREFIX = "dkv-client-java";
    private static final long DEFAULT_REQUEST_TIMEOUT = 5000L;
    private static final long DEFAULT_CONNECT_TIMEOUT = 5000L;
    private Long requestTimeout;
    private Long readTimeout;
    private Long writeTimeout;
    private Long connectTimeout;
    private String metricPrefix;

    private long getRequestTimeout() {
        return this.requestTimeout != null ? this.requestTimeout : 5000L;
    }

    public long getReadTimeout() {
        return this.readTimeout != null ? this.readTimeout.longValue() : this.getRequestTimeout();
    }

    public long getWriteTimeout() {
        return this.writeTimeout != null ? this.writeTimeout.longValue() : this.getRequestTimeout();
    }

    public long getConnectTimeout() {
        return this.connectTimeout != null ? this.connectTimeout : 5000L;
    }

    public String getMetricPrefix() {
        return this.metricPrefix == null ? DEF_METRIC_PREFIX : this.metricPrefix.trim();
    }

    ConnectionOptions(Long requestTimeout, Long readTimeout, Long writeTimeout, Long connectTimeout, String metricPrefix) {
        this.requestTimeout = requestTimeout;
        this.readTimeout = readTimeout;
        this.writeTimeout = writeTimeout;
        this.connectTimeout = connectTimeout;
        this.metricPrefix = metricPrefix;
    }

    public static ConnectionOptionsBuilder builder() {
        return new ConnectionOptionsBuilder();
    }

    public void setRequestTimeout(Long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public void setReadTimeout(Long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setWriteTimeout(Long writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public void setConnectTimeout(Long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setMetricPrefix(String metricPrefix) {
        this.metricPrefix = metricPrefix;
    }

    public static class ConnectionOptionsBuilder {
        private Long requestTimeout;
        private Long readTimeout;
        private Long writeTimeout;
        private Long connectTimeout;
        private String metricPrefix;

        ConnectionOptionsBuilder() {
        }

        public ConnectionOptionsBuilder requestTimeout(Long requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        public ConnectionOptionsBuilder readTimeout(Long readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public ConnectionOptionsBuilder writeTimeout(Long writeTimeout) {
            this.writeTimeout = writeTimeout;
            return this;
        }

        public ConnectionOptionsBuilder connectTimeout(Long connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public ConnectionOptionsBuilder metricPrefix(String metricPrefix) {
            this.metricPrefix = metricPrefix;
            return this;
        }

        public ConnectionOptions build() {
            return new ConnectionOptions(this.requestTimeout, this.readTimeout, this.writeTimeout, this.connectTimeout, this.metricPrefix);
        }

        public String toString() {
            return "ConnectionOptions.ConnectionOptionsBuilder(requestTimeout=" + this.requestTimeout + ", readTimeout=" + this.readTimeout + ", writeTimeout=" + this.writeTimeout + ", connectTimeout=" + this.connectTimeout + ", metricPrefix=" + this.metricPrefix + ")";
        }
    }
}

