/*
 * Decompiled with CFR 0.152.
 */
package org.dkv.client;

import com.google.protobuf.ByteString;
import dkv.serverpb.Api;
import org.dkv.client.DKVException;

public class DKVEntry {
    private final Api.Status iterStatus;
    private final ByteString iterKey;
    private final ByteString iterVal;

    DKVEntry(Api.IterateResponse iterRes) {
        this.iterStatus = iterRes.getStatus();
        this.iterKey = iterRes.getKey();
        this.iterVal = iterRes.getValue();
    }

    public void checkStatus() {
        if (this.iterStatus.getCode() != 0) {
            throw new DKVException(this.iterStatus, "iterate", null);
        }
    }

    public String getKeyAsString() {
        if (this.iterKey == null) {
            throw new IllegalStateException("current entry is in error status");
        }
        return this.iterKey.toStringUtf8();
    }

    public byte[] getKeyAsByteArray() {
        if (this.iterKey == null) {
            throw new IllegalStateException("current entry is in error status");
        }
        return this.iterKey.toByteArray();
    }

    public String getValueAsString() {
        if (this.iterKey == null) {
            throw new IllegalStateException("current entry is in error status");
        }
        return this.iterVal.toStringUtf8();
    }

    public byte[] getValueAsByteArray() {
        if (this.iterKey == null) {
            throw new IllegalStateException("current entry is in error status");
        }
        return this.iterVal.toByteArray();
    }
}

