/*
 * Decompiled with CFR 0.152.
 */
package org.dkv.client;

import org.dkv.client.DKVShard;
import org.dkv.client.Utils;

public class ShardConfiguration {
    private final DKVShard[] dkvShards;

    public ShardConfiguration(DKVShard[] dkvShards) {
        Utils.checkf(dkvShards != null && dkvShards.length > 0, IllegalArgumentException.class, "must provide DKV shards in shard configuration", new Object[0]);
        this.dkvShards = new DKVShard[dkvShards.length];
        System.arraycopy(dkvShards, 0, this.dkvShards, 0, dkvShards.length);
    }

    public DKVShard getShardAtIndex(int idx) {
        Utils.checkf(idx >= 0 && idx < this.dkvShards.length, IllegalArgumentException.class, "given index is invalid: %d", idx);
        return this.dkvShards[idx];
    }

    public long getNumShards() {
        return this.dkvShards.length;
    }

    private ShardConfiguration() {
        this.dkvShards = null;
    }
}

