/*
 * Decompiled with CFR 0.152.
 */
package org.dkv.client;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.google.common.collect.Iterables;
import dkv.serverpb.Api;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.dkv.client.ConnectionOptions;
import org.dkv.client.DKVClient;
import org.dkv.client.DKVEntry;
import org.dkv.client.DKVNode;
import org.dkv.client.DKVNodeSet;
import org.dkv.client.DKVNodeType;
import org.dkv.client.DKVShard;
import org.dkv.client.KV;
import org.dkv.client.ShardProvider;
import org.dkv.client.SimpleDKVClient;
import org.dkv.client.Utils;

public class ShardedDKVClient
implements DKVClient {
    private static final int POOL_SIZE = 1000;
    private final ShardProvider shardProvider;
    private final DKVClientPool pool;

    public ShardedDKVClient(ShardProvider shardProvider, ConnectionOptions options) {
        Utils.checkf(shardProvider != null, IllegalArgumentException.class, "Shard provider must be provided", new Object[0]);
        this.shardProvider = shardProvider;
        this.pool = new DKVClientPool(1000L, options);
    }

    @Override
    public void put(String key, String value) {
        DKVShard dkvShard = this.shardProvider.provideShard(key);
        Utils.checkf(dkvShard != null, IllegalArgumentException.class, "unable to compute shard for the given key: %s", key);
        SimpleDKVClient dkvClient = this.pool.getDKVClient(dkvShard, DKVNodeType.MASTER, DKVNodeType.UNKNOWN);
        dkvClient.put(key, value);
    }

    @Override
    public void put(byte[] key, byte[] value) {
        DKVShard dkvShard = this.shardProvider.provideShard(key);
        Utils.checkf(dkvShard != null, IllegalArgumentException.class, "unable to compute shard for the given key", new Object[0]);
        SimpleDKVClient dkvClient = this.pool.getDKVClient(dkvShard, DKVNodeType.MASTER, DKVNodeType.UNKNOWN);
        dkvClient.put(key, value);
    }

    @Override
    public boolean compareAndSet(byte[] key, byte[] expect, byte[] update) {
        DKVShard dkvShard = this.shardProvider.provideShard(key);
        Utils.checkf(dkvShard != null, IllegalArgumentException.class, "unable to compute shard for the given key", new Object[0]);
        SimpleDKVClient dkvClient = this.pool.getDKVClient(dkvShard, DKVNodeType.MASTER, DKVNodeType.UNKNOWN);
        return dkvClient.compareAndSet(key, expect, update);
    }

    @Override
    public long incrementAndGet(byte[] key) {
        DKVShard dkvShard = this.shardProvider.provideShard(key);
        Utils.checkf(dkvShard != null, IllegalArgumentException.class, "unable to compute shard for the given key", new Object[0]);
        SimpleDKVClient dkvClient = this.pool.getDKVClient(dkvShard, DKVNodeType.MASTER, DKVNodeType.UNKNOWN);
        return dkvClient.incrementAndGet(key);
    }

    @Override
    public long decrementAndGet(byte[] key) {
        DKVShard dkvShard = this.shardProvider.provideShard(key);
        Utils.checkf(dkvShard != null, IllegalArgumentException.class, "unable to compute shard for the given key", new Object[0]);
        SimpleDKVClient dkvClient = this.pool.getDKVClient(dkvShard, DKVNodeType.MASTER, DKVNodeType.UNKNOWN);
        return dkvClient.decrementAndGet(key);
    }

    @Override
    public long addAndGet(byte[] key, long delta) {
        DKVShard dkvShard = this.shardProvider.provideShard(key);
        Utils.checkf(dkvShard != null, IllegalArgumentException.class, "unable to compute shard for the given key", new Object[0]);
        SimpleDKVClient dkvClient = this.pool.getDKVClient(dkvShard, DKVNodeType.MASTER, DKVNodeType.UNKNOWN);
        return dkvClient.addAndGet(key, delta);
    }

    @Override
    public void put(String key, String value, long expiryTS) {
        DKVShard dkvShard = this.shardProvider.provideShard(key);
        Utils.checkf(dkvShard != null, IllegalArgumentException.class, "unable to compute shard for the given key: %s", key);
        SimpleDKVClient dkvClient = this.pool.getDKVClient(dkvShard, DKVNodeType.MASTER, DKVNodeType.UNKNOWN);
        dkvClient.put(key, value, expiryTS);
    }

    @Override
    public void put(byte[] key, byte[] value, long expiryTS) {
        DKVShard dkvShard = this.shardProvider.provideShard(key);
        Utils.checkf(dkvShard != null, IllegalArgumentException.class, "unable to compute shard for the given key: %s", new Object[]{key});
        SimpleDKVClient dkvClient = this.pool.getDKVClient(dkvShard, DKVNodeType.MASTER, DKVNodeType.UNKNOWN);
        dkvClient.put(key, value, expiryTS);
    }

    @Override
    public void put(KV.Strings ... items) {
        Utils.checkf(items != null && items.length > 0, IllegalArgumentException.class, "must provide at least one kv for multi put", new Object[0]);
        String[] keys = (String[])Arrays.stream(items).map(KV::getKey).toArray(String[]::new);
        Map<DKVShard, List<String>> dkvShards = this.shardProvider.provideShards(keys);
        Utils.checkf(dkvShards != null && !dkvShards.isEmpty(), IllegalArgumentException.class, "unable to compute shard(s) for the given keys", new Object[0]);
        Utils.checkf(dkvShards != null && dkvShards.size() == 1, UnsupportedOperationException.class, "DKV does not yet support cross shard multi put", new Object[0]);
        DKVShard dkvShard = (DKVShard)Iterables.get(dkvShards.keySet(), (int)0);
        SimpleDKVClient dkvClient = this.pool.getDKVClient(dkvShard, DKVNodeType.MASTER, DKVNodeType.UNKNOWN);
        dkvClient.put(items);
    }

    @Override
    public void put(KV.Bytes ... items) {
        Utils.checkf(items != null && items.length > 0, IllegalArgumentException.class, "must provide at least one kv for multi put", new Object[0]);
        byte[][] keys = (byte[][])Arrays.stream(items).map(KV::getKey).toArray(x$0 -> new byte[x$0][]);
        Map<DKVShard, List<byte[]>> dkvShards = this.shardProvider.provideShards(keys);
        Utils.checkf(dkvShards != null && !dkvShards.isEmpty(), IllegalArgumentException.class, "unable to compute shard(s) for the given keys", new Object[0]);
        Utils.checkf(dkvShards != null && dkvShards.size() == 1, UnsupportedOperationException.class, "DKV does not yet support cross shard multi put", new Object[0]);
        DKVShard dkvShard = (DKVShard)Iterables.get(dkvShards.keySet(), (int)0);
        SimpleDKVClient dkvClient = this.pool.getDKVClient(dkvShard, DKVNodeType.MASTER, DKVNodeType.UNKNOWN);
        dkvClient.put(items);
    }

    @Override
    public String get(Api.ReadConsistency consistency, String key) {
        DKVShard dkvShard = this.shardProvider.provideShard(key);
        Utils.checkf(dkvShard != null, IllegalArgumentException.class, "unable to compute shard for the given key: %s", key);
        DKVNodeType nodeType = DKVNodeType.getNodeTypeByReadConsistency(consistency);
        SimpleDKVClient dkvClient = this.pool.getDKVClient(dkvShard, nodeType, DKVNodeType.UNKNOWN);
        return dkvClient.get(consistency, key);
    }

    @Override
    public byte[] get(Api.ReadConsistency consistency, byte[] key) {
        DKVShard dkvShard = this.shardProvider.provideShard(key);
        Utils.checkf(dkvShard != null, IllegalArgumentException.class, "unable to compute shard for the given key", new Object[0]);
        DKVNodeType nodeType = DKVNodeType.getNodeTypeByReadConsistency(consistency);
        SimpleDKVClient dkvClient = this.pool.getDKVClient(dkvShard, nodeType, DKVNodeType.UNKNOWN);
        return dkvClient.get(consistency, key);
    }

    @Override
    public KV.Strings[] multiGet(Api.ReadConsistency consistency, String[] keys) {
        Utils.checkf(keys != null && keys.length > 0, IllegalArgumentException.class, "must provide at least one key for multi get", new Object[0]);
        Map<DKVShard, List<String>> dkvShards = this.shardProvider.provideShards(keys);
        Utils.checkf(dkvShards != null && !dkvShards.isEmpty(), IllegalArgumentException.class, "unable to compute shard(s) for the given keys", new Object[0]);
        DKVNodeType nodeType = DKVNodeType.getNodeTypeByReadConsistency(consistency);
        if (dkvShards.size() > 1) {
            Utils.checkf(consistency != Api.ReadConsistency.LINEARIZABLE, UnsupportedOperationException.class, "DKV does not yet support cross shard linearizable multi get", new Object[0]);
            LinkedList result = new LinkedList();
            for (Map.Entry<DKVShard, List<String>> entry : dkvShards.entrySet()) {
                SimpleDKVClient dkvClient = this.pool.getDKVClient(entry.getKey(), nodeType, DKVNodeType.UNKNOWN);
                String[] reqKeys = entry.getValue().toArray(new String[0]);
                KV.Strings[] kvs = dkvClient.multiGet(consistency, reqKeys);
                Collections.addAll(result, kvs);
            }
            return result.toArray(new KV.Strings[0]);
        }
        DKVShard dkvShard = (DKVShard)Iterables.get(dkvShards.keySet(), (int)0);
        SimpleDKVClient dkvClient = this.pool.getDKVClient(dkvShard, nodeType, DKVNodeType.UNKNOWN);
        return dkvClient.multiGet(consistency, keys);
    }

    @Override
    public KV.Bytes[] multiGet(Api.ReadConsistency consistency, byte[][] keys) {
        Utils.checkf(keys != null && keys.length > 0, IllegalArgumentException.class, "must provide at least one key for multi get", new Object[0]);
        Map<DKVShard, List<byte[]>> dkvShards = this.shardProvider.provideShards(keys);
        Utils.checkf(dkvShards != null && !dkvShards.isEmpty(), IllegalArgumentException.class, "unable to compute shard(s) for the given keys", new Object[0]);
        DKVNodeType nodeType = DKVNodeType.getNodeTypeByReadConsistency(consistency);
        if (dkvShards.size() > 1) {
            Utils.checkf(consistency != Api.ReadConsistency.LINEARIZABLE, UnsupportedOperationException.class, "DKV does not yet support cross shard linearizable multi get", new Object[0]);
            LinkedList result = new LinkedList();
            for (Map.Entry<DKVShard, List<byte[]>> entry : dkvShards.entrySet()) {
                SimpleDKVClient dkvClient = this.pool.getDKVClient(entry.getKey(), nodeType, DKVNodeType.UNKNOWN);
                byte[][] reqKeys = (byte[][])entry.getValue().toArray((T[])new byte[0][]);
                KV.Bytes[] kvs = dkvClient.multiGet(consistency, reqKeys);
                Collections.addAll(result, kvs);
            }
            return result.toArray(new KV.Bytes[0]);
        }
        DKVShard dkvShard = (DKVShard)Iterables.get(dkvShards.keySet(), (int)0);
        SimpleDKVClient dkvClient = this.pool.getDKVClient(dkvShard, nodeType, DKVNodeType.UNKNOWN);
        return dkvClient.multiGet(consistency, keys);
    }

    @Override
    public void delete(String key) {
        DKVShard dkvShard = this.shardProvider.provideShard(key);
        Utils.checkf(dkvShard != null, IllegalArgumentException.class, "unable to compute shard for the given key", new Object[0]);
        SimpleDKVClient dkvClient = this.pool.getDKVClient(dkvShard, DKVNodeType.MASTER, DKVNodeType.UNKNOWN);
        dkvClient.delete(key);
    }

    @Override
    public void delete(byte[] key) {
        DKVShard dkvShard = this.shardProvider.provideShard(key);
        Utils.checkf(dkvShard != null, IllegalArgumentException.class, "unable to compute shard for the given key", new Object[0]);
        SimpleDKVClient dkvClient = this.pool.getDKVClient(dkvShard, DKVNodeType.MASTER, DKVNodeType.UNKNOWN);
        dkvClient.delete(key);
    }

    @Override
    public Iterator<DKVEntry> iterate(String startKey) {
        DKVShard dkvShard = this.shardProvider.provideShard(startKey);
        Utils.checkf(dkvShard != null, IllegalArgumentException.class, "unable to compute shard for the given start key: %s", startKey);
        SimpleDKVClient dkvClient = this.pool.getDKVClient(dkvShard, DKVNodeType.SLAVE, DKVNodeType.UNKNOWN);
        return dkvClient.iterate(startKey);
    }

    @Override
    public Iterator<DKVEntry> iterate(byte[] startKey) {
        DKVShard dkvShard = this.shardProvider.provideShard(startKey);
        Utils.checkf(dkvShard != null, IllegalArgumentException.class, "unable to compute shard for the given start key", new Object[0]);
        SimpleDKVClient dkvClient = this.pool.getDKVClient(dkvShard, DKVNodeType.SLAVE, DKVNodeType.UNKNOWN);
        return dkvClient.iterate(startKey);
    }

    @Override
    public Iterator<DKVEntry> iterate(String startKey, String keyPref) {
        DKVShard dkvShard = this.shardProvider.provideShard(startKey);
        Utils.checkf(dkvShard != null, IllegalArgumentException.class, "unable to compute shard for the given start key: %s", startKey);
        SimpleDKVClient dkvClient = this.pool.getDKVClient(dkvShard, DKVNodeType.SLAVE, DKVNodeType.UNKNOWN);
        return dkvClient.iterate(startKey, keyPref);
    }

    @Override
    public Iterator<DKVEntry> iterate(byte[] startKey, byte[] keyPref) {
        DKVShard dkvShard = this.shardProvider.provideShard(startKey);
        Utils.checkf(dkvShard != null, IllegalArgumentException.class, "unable to compute shard for the given start key", new Object[0]);
        SimpleDKVClient dkvClient = this.pool.getDKVClient(dkvShard, DKVNodeType.SLAVE, DKVNodeType.UNKNOWN);
        return dkvClient.iterate(startKey, keyPref);
    }

    @Override
    public void close() {
        this.pool.close();
    }

    private static class DKVClientPool
    implements Closeable,
    RemovalListener<Key, SimpleDKVClient>,
    CacheLoader<Key, SimpleDKVClient> {
        private final LoadingCache<Key, SimpleDKVClient> internalPool;
        private final ConnectionOptions connectionOptions;

        private DKVClientPool(long poolSize, ConnectionOptions options) {
            this.internalPool = Caffeine.newBuilder().maximumSize(poolSize).removalListener((RemovalListener)this).build((CacheLoader)this);
            this.connectionOptions = options;
        }

        SimpleDKVClient getDKVClient(DKVShard dkvShard, DKVNodeType ... nodeTypes) {
            DKVNodeSet nodeSet = dkvShard.getNodesByType(nodeTypes);
            DKVNode dkvNode = nodeSet.getNextNode();
            return (SimpleDKVClient)this.internalPool.get((Object)new Key(dkvNode, nodeSet.getName(), dkvShard.getName()));
        }

        @Override
        public void close() {
            this.internalPool.invalidateAll();
        }

        public void onRemoval(Key id, SimpleDKVClient client, RemovalCause removalCause) {
            if (client != null) {
                client.close();
            }
        }

        public SimpleDKVClient load(Key key) {
            this.connectionOptions.setMetricPrefix(key.shardName);
            return new SimpleDKVClient(key.dkvNode.getAddress(), key.authority, this.connectionOptions);
        }

        public SimpleDKVClient reload(Key key, SimpleDKVClient oldClient) {
            oldClient.close();
            return this.load(key);
        }

        private static class Key {
            private final DKVNode dkvNode;
            private final String authority;
            private final String shardName;

            private Key(DKVNode dkvNode, String authority, String shardName) {
                this.dkvNode = dkvNode;
                this.authority = authority;
                this.shardName = shardName;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Key that = (Key)o;
                return Objects.equals(this.dkvNode, that.dkvNode) && Objects.equals(this.authority, that.authority);
            }

            public int hashCode() {
                return Objects.hash(this.dkvNode, this.authority);
            }
        }
    }
}

