/*
 * Decompiled with CFR 0.152.
 */
package org.dkv.client.metrics;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;

public class MetricsInterceptor
implements ClientInterceptor {
    private final MetricRegistry metrics;

    public MetricsInterceptor(MetricRegistry metrics) {
        this.metrics = metrics;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
        String grpcName = methodDescriptor.getFullMethodName().replace('/', '.');
        Meter requests = this.metrics.meter(grpcName + ".requests");
        Meter errors = this.metrics.meter(grpcName + ".errors");
        Timer timer = this.metrics.timer(grpcName + ".latencies");
        return new MonitoringClientCall(channel.newCall(methodDescriptor, callOptions), requests, errors, timer);
    }

    private static class MonitoringClientCallListener<RespT>
    extends ForwardingClientCallListener<RespT> {
        private final ClientCall.Listener<RespT> delegate;
        private final Meter errors;
        private final Timer.Context responseTimer;

        public MonitoringClientCallListener(ClientCall.Listener<RespT> delegate, Meter errors, Timer.Context responseTimer) {
            this.delegate = delegate;
            this.errors = errors;
            this.responseTimer = responseTimer;
        }

        protected ClientCall.Listener<RespT> delegate() {
            return this.delegate;
        }

        public void onClose(Status status, Metadata trailers) {
            this.responseTimer.stop();
            if (!status.isOk()) {
                this.errors.mark();
            }
            super.onClose(status, trailers);
        }
    }

    private static class MonitoringClientCall<ReqT, RespT>
    extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
        private final Meter requests;
        private final Meter errors;
        private final Timer timer;

        public MonitoringClientCall(ClientCall<ReqT, RespT> clientCall, Meter requests, Meter errors, Timer timer) {
            super(clientCall);
            this.requests = requests;
            this.errors = errors;
            this.timer = timer;
        }

        public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
            this.requests.mark();
            super.start(new MonitoringClientCallListener<RespT>(responseListener, this.errors, this.timer.time()), headers);
        }
    }
}

