/*
 * Decompiled with CFR 0.152.
 */
package org.dkv.client;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.openhft.hashing.LongHashFunction;
import org.dkv.client.DKVShard;
import org.dkv.client.ShardConfiguration;
import org.dkv.client.ShardProvider;
import org.dkv.client.Utils;

public class KeyHashBasedShardProvider
implements ShardProvider {
    private final ShardConfiguration shardConfiguration;

    public KeyHashBasedShardProvider(ShardConfiguration shardConfiguration) {
        Utils.checkf(shardConfiguration != null, IllegalArgumentException.class, "shard configuration must be provided", new Object[0]);
        this.shardConfiguration = shardConfiguration;
    }

    @Override
    public DKVShard provideShard(byte[] key) {
        int shardId = this.getShardId(key);
        return this.shardConfiguration.getShardAtIndex(shardId);
    }

    @Override
    public DKVShard provideShard(String key) {
        int shardId = this.getShardId(key.getBytes(StandardCharsets.UTF_8));
        return this.shardConfiguration.getShardAtIndex(shardId);
    }

    @Override
    public Map<DKVShard, List<byte[]>> provideShards(byte[] ... keys) {
        Utils.checkf(keys != null && keys.length > 0, IllegalArgumentException.class, "must provide at least one key for providing shards", new Object[0]);
        HashMap<DKVShard, List<byte[]>> result = new HashMap<DKVShard, List<byte[]>>();
        int numKeys = keys.length;
        for (byte[] key : keys) {
            DKVShard dkvShard = this.provideShard(key);
            result.putIfAbsent(dkvShard, new ArrayList(numKeys));
            result.get(dkvShard).add(key);
        }
        return result;
    }

    @Override
    public Map<DKVShard, List<String>> provideShards(String ... keys) {
        Utils.checkf(keys != null && keys.length > 0, IllegalArgumentException.class, "must provide at least one key for providing shards", new Object[0]);
        HashMap<DKVShard, List<String>> result = new HashMap<DKVShard, List<String>>();
        int numKeys = keys.length;
        for (String key : keys) {
            DKVShard dkvShard = this.provideShard(key);
            result.putIfAbsent(dkvShard, new ArrayList(numKeys));
            result.get(dkvShard).add(key);
        }
        return result;
    }

    private int getShardId(byte[] key) {
        LongHashFunction xx = LongHashFunction.xx();
        long hsh = xx.hashBytes(key);
        return (int)((hsh & 0xFFFFL) % this.shardConfiguration.getNumShards());
    }
}

