/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.hadoop.ambari;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.flipkart.fdp.irm.exceptions.EFailure;
import com.flipkart.fdp.irm.hadoop.ambari.AmbariRequestPayload;
import com.flipkart.fdp.irm.hadoop.ambari.FairSchedulerPayload;
import com.flipkart.fdp.irm.hadoop.ambari.IAmbariConnector;
import com.flipkart.fdp.irm.utils.CommonUtils;
import com.flipkart.fdp.irm.utils.RestConnector;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAmbariConnector
implements IAmbariConnector {
    private static final Logger log = LoggerFactory.getLogger(CAmbariConnector.class);
    public static final String CLUSTER_CONFIGS = "/api/v1/clusters/%s/configurations";
    public static final String AMBARI_REQUESTS = "/api/v1/clusters/%s/requests";
    public static final String CLUSTER_DETAILS = "/api/v1/clusters/%s";
    public static final String CAPACITY_SCHEDULER = "capacity-scheduler";
    public static final String FAIR_SCHEDULER = "fair-scheduler";
    public static final String YARN_SITE = "yarn-site";
    public static final String CORE_SITE = "core-site";
    private String ambariUrl;
    private String clusterName;
    private RestConnector restConnector;

    public CAmbariConnector(String clusterName, String ambariUrl, String ambariUser, String ambariPassword) {
        this.clusterName = clusterName;
        this.ambariUrl = ambariUrl;
        this.restConnector = new RestConnector();
        this.restConnector.setAuthEncoding(ambariUser, ambariPassword);
    }

    @Override
    public YarnConfiguration getYarnConfiguration() throws EFailure {
        Map properties = this.getConfiguration(YARN_SITE);
        YarnConfiguration yarnConfiguration = new YarnConfiguration();
        for (Map.Entry property : properties.entrySet()) {
            yarnConfiguration.set((String)property.getKey(), (String)property.getValue());
        }
        return yarnConfiguration;
    }

    private Map getConfiguration(String type) throws EFailure {
        try {
            String tag = this.getConfigTag(type);
            JsonNode responseJson = this.getJsonConfiguration(type, tag);
            JsonNode properties = responseJson.get("items").get(0).get("properties");
            return (Map)CommonUtils.OBJECT_MAPPER.readValue(properties.toString(), Map.class);
        }
        catch (IOException e) {
            log.error("Error while fetching configs from ambari. {} {}", (Object)this.ambariUrl, (Object)this.clusterName);
            throw new EFailure("Error while fetching configs from ambari." + this.ambariUrl + ", " + this.clusterName);
        }
        catch (URISyntaxException e) {
            log.error("Exception while fetching configuration from ambari.");
            throw new EFailure((Exception)e);
        }
    }

    private JsonNode getJsonConfiguration(String type, String tag) throws URISyntaxException, EFailure, IOException {
        URI ambariURI = CommonUtils.constructURI((String)this.ambariUrl, (String)String.format(CLUSTER_CONFIGS, this.clusterName), (Map)ImmutableMap.of((Object)"type", (Object)type, (Object)"tag", (Object)tag));
        String response = this.restConnector.hitGetURI(ambariURI, Optional.empty());
        Preconditions.checkNotNull((Object)response);
        return (JsonNode)CommonUtils.OBJECT_MAPPER.readValue(response, JsonNode.class);
    }

    @Override
    public Configuration getCoreConfiguration() throws EFailure {
        Map properties = this.getConfiguration(CORE_SITE);
        Configuration configuration = new Configuration();
        for (Map.Entry property : properties.entrySet()) {
            configuration.set((String)property.getKey(), (String)property.getValue());
        }
        return configuration;
    }

    @Override
    public void updateFairSchedulerConfig(String content, String rmHosts) throws EFailure {
        this.updateConfigInAmbari(content);
        AmbariRequestPayload ambariRequestPayload = this.getSchedulerRefresherPayload(rmHosts);
        this.ambariRequest(ambariRequestPayload);
    }

    private String updateConfigInAmbari(String content) throws EFailure {
        String data = this.getFairSchedulerPayload(content);
        try {
            URI ambariURI = CommonUtils.constructURI((String)this.ambariUrl, (String)String.format(CLUSTER_DETAILS, this.clusterName), null);
            Header[] headers = new Header[]{new BasicHeader("X-Requested-By", "ambari")};
            String response = this.restConnector.hitPutURI(ambariURI, Optional.of(data), Optional.of(headers));
            return response;
        }
        catch (URISyntaxException e) {
            log.error("Exception while updating fair scheduler configuration in ambari.");
            throw new EFailure((Exception)e);
        }
    }

    private AmbariRequestPayload getSchedulerRefresherPayload(String hosts) {
        AmbariRequestPayload ambariRequestPayload = new AmbariRequestPayload();
        ambariRequestPayload.getRequestInfo().setCommand("REFRESHQUEUES");
        ambariRequestPayload.getRequestInfo().setContext("Refresh YARN Scheduler");
        AmbariRequestPayload.Request request = ambariRequestPayload.getNewRequest();
        request.setComponentName("RESOURCEMANAGER");
        request.setServiceName("YARN");
        request.setHosts(hosts);
        ambariRequestPayload.getRequestList().add(request);
        return ambariRequestPayload;
    }

    private String ambariRequest(AmbariRequestPayload content) throws EFailure {
        try {
            String data = CommonUtils.OBJECT_MAPPER.writeValueAsString((Object)content);
            URI ambariURI = CommonUtils.constructURI((String)this.ambariUrl, (String)String.format(AMBARI_REQUESTS, this.clusterName), null);
            Header[] headers = new Header[]{new BasicHeader("X-Requested-By", "ambari")};
            String response = this.restConnector.hitPostURI(ambariURI, data, Optional.of(headers));
            return response;
        }
        catch (JsonProcessingException e) {
            log.error("Exception while processing ambariRequestPayload");
            throw new EFailure((Exception)((Object)e));
        }
        catch (URISyntaxException e) {
            log.error("Exception while sending requests to ambari");
            throw new EFailure((Exception)e);
        }
    }

    private String getFairSchedulerPayload(String content) throws EFailure {
        FairSchedulerPayload fairSchedulerPayload = new FairSchedulerPayload();
        Properties properties = new Properties();
        properties.setProperty("content", content);
        fairSchedulerPayload.getClusters().getDesiredConfig().setProperties(properties);
        try {
            return CommonUtils.OBJECT_MAPPER.writeValueAsString((Object)fairSchedulerPayload);
        }
        catch (JsonProcessingException e) {
            log.error("Exception while processing fairSchedulerPayload");
            throw new EFailure((Exception)((Object)e));
        }
    }

    public String getConfigTag(String configName) throws EFailure {
        try {
            URI ambariURI = CommonUtils.constructURI((String)this.ambariUrl, (String)String.format(CLUSTER_DETAILS, this.clusterName), (Map)ImmutableMap.of((Object)"fields", (Object)("Clusters/desired_configs/" + configName)));
            String response = this.restConnector.hitGetURI(ambariURI, Optional.empty());
            Preconditions.checkNotNull((Object)response);
            JsonNode responseJson = (JsonNode)CommonUtils.OBJECT_MAPPER.readValue(response, JsonNode.class);
            return responseJson.get("Clusters").get("desired_configs").get(configName).get("tag").toString();
        }
        catch (URISyntaxException e) {
            log.error("Exception while fetching configuration from ambari.");
            throw new EFailure((Exception)e);
        }
        catch (IOException e) {
            log.error("Error while fetching configs from ambari. {} {}", (Object)this.ambariUrl, (Object)this.clusterName);
            throw new EFailure("Error while fetching configs from ambari." + this.ambariUrl + ", " + this.clusterName);
        }
    }
}

