/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.hadoop.hdfs.clients;

import com.flipkart.fdp.irm.core.clients.IClusterClient;
import com.flipkart.fdp.irm.exceptions.EFailure;
import com.flipkart.fdp.irm.hadoop.HadoopClusterHelper;
import com.flipkart.fdp.irm.webentities.HdfsClusterUsage;
import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHdfsClusterClient
implements IClusterClient<HdfsClusterUsage> {
    private static final Logger log = LoggerFactory.getLogger(CHdfsClusterClient.class);
    private FileSystem fs;

    public CHdfsClusterClient(String hdfsUri) throws EFailure {
        HadoopClusterHelper hadoopClusterHelper = new HadoopClusterHelper();
        this.fs = hadoopClusterHelper.getFileSystem(hdfsUri);
    }

    public HdfsClusterUsage getClusterQuotaDetails() throws EFailure {
        HdfsClusterUsage hdfsClusterUsage = new HdfsClusterUsage();
        try {
            FsStatus fsStatus = this.fs.getStatus();
            hdfsClusterUsage.setDiskSpaceUsed(fsStatus.getUsed());
            hdfsClusterUsage.setDiskSpaceTotal(fsStatus.getCapacity());
            hdfsClusterUsage.setDiskSpaceRemaining(fsStatus.getRemaining());
        }
        catch (IOException e) {
            log.error("Exception while fetching hdfs cluster stats {}", (Object)e.getMessage());
            throw new EFailure((Exception)e);
        }
        return hdfsClusterUsage;
    }
}

