/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.hadoop.hdfs.clients;

import com.flipkart.fdp.irm.core.clients.IResourceClient;
import com.flipkart.fdp.irm.core.db.QuotaReservation;
import com.flipkart.fdp.irm.core.db.Resource;
import com.flipkart.fdp.irm.exceptions.EBase;
import com.flipkart.fdp.irm.exceptions.EFailure;
import com.flipkart.fdp.irm.hadoop.HadoopClusterHelper;
import com.flipkart.fdp.irm.webentities.HdfsQuotaWebEntity;
import com.flipkart.fdp.irm.webentities.HdfsResourceUsage;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.client.HdfsAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHdfsResourceClient
implements IResourceClient<HdfsQuotaWebEntity, HdfsResourceUsage> {
    private static final Logger log = LoggerFactory.getLogger(CHdfsResourceClient.class);
    private FileSystem fs;
    private HdfsAdmin hdfsAdmin;

    public CHdfsResourceClient(String hdfsUri) throws EFailure {
        HadoopClusterHelper hadoopClusterHelper = new HadoopClusterHelper();
        this.fs = hadoopClusterHelper.getFileSystem(hdfsUri);
        this.hdfsAdmin = hadoopClusterHelper.getHdfsAdmin(hdfsUri);
    }

    public void createResource(Resource resource) throws EFailure {
        Path path = this.getPathForResource(resource.getToken());
        this.createDirectory(path);
        this.setQuota((HdfsQuotaWebEntity)resource.getQuota(), path);
    }

    public HdfsResourceUsage getUsage(Resource resource) throws EFailure {
        Path path = this.getPathForResource(resource.getToken());
        return this.getHdfsResourceUsage(resource.getCluster().getId(), path);
    }

    public HdfsResourceUsage getReservationUsage(QuotaReservation quotaReservation) throws URISyntaxException, EBase {
        Path path = this.getQuotaPath(quotaReservation.getNamespaceName(), quotaReservation.getOrgName());
        return this.getHdfsResourceUsage(quotaReservation.getCluster().getId(), path);
    }

    private HdfsResourceUsage getHdfsResourceUsage(long clusterId, Path path) throws EFailure {
        long total;
        long usage;
        try {
            ContentSummary contentSummary = this.fs.getContentSummary(path);
            usage = contentSummary.getSpaceConsumed();
            total = contentSummary.getSpaceQuota();
        }
        catch (IOException e) {
            log.info("Exception while Checking usage of HDFS directory: {}, {}", (Object)path.getName(), (Object)e.getMessage());
            throw new EFailure((Exception)e);
        }
        HdfsResourceUsage hdfsResourceUsage = new HdfsResourceUsage(path.toString(), usage, total);
        hdfsResourceUsage.setClusterId(Long.valueOf(clusterId));
        return hdfsResourceUsage;
    }

    public void updateResourceQuota(Resource resource) throws EFailure {
        Path path = this.getPathForResource(resource.getToken());
        this.setQuota((HdfsQuotaWebEntity)resource.getQuota(), path);
    }

    public void reserveResourceQuota(QuotaReservation quotaReservation) throws EFailure {
        Path path = this.getQuotaPath(quotaReservation.getNamespaceName(), quotaReservation.getOrgName());
        this.createDirectory(path);
        this.setQuota((HdfsQuotaWebEntity)quotaReservation.getQuota(), path);
    }

    private Path getQuotaPath(String namespace, String org) {
        String quotaPath = namespace != null ? "/" + org + "/" + namespace : "/" + org;
        return new Path(quotaPath);
    }

    public void updateReservedQuota(QuotaReservation quotaReservation) throws EFailure {
        Path path = this.getQuotaPath(quotaReservation.getNamespaceName(), quotaReservation.getOrgName());
        this.setQuota((HdfsQuotaWebEntity)quotaReservation.getQuota(), path);
    }

    private Path getPathForResource(String pathString) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)pathString) ? 1 : 0) != 0, (Object)"Resource token cannot be null or empty");
        return new Path(pathString);
    }

    private void createDirectory(Path path) throws EFailure {
        try {
            this.fs.mkdirs(path);
        }
        catch (IOException e) {
            log.info("Exception while creating HDFS directory: {}, {}", (Object)path.getName(), (Object)e.getMessage());
            throw new EFailure((Exception)e);
        }
    }

    private void setQuota(HdfsQuotaWebEntity hdfsQuota, Path path) throws EFailure {
        try {
            Preconditions.checkNotNull((Object)this.hdfsAdmin, (Object)"Some issue while instantiating hdfs");
            Preconditions.checkNotNull((Object)hdfsQuota, (Object)"Quota cannot be null.");
            Preconditions.checkNotNull((Object)path, (Object)"Path cannot be null");
            this.hdfsAdmin.setSpaceQuota(path, hdfsQuota.getDiskSpace());
        }
        catch (IOException e) {
            log.info("Exception while setting space quota for HDFS directory: {}, {}", (Object)path.getName(), (Object)e.getMessage());
            throw new EFailure((Exception)e);
        }
    }
}

