/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.fdp.irm.hadoop.hdfs.facade;

import com.flipkart.fdp.irm.core.dao.IResourceProfileDao;
import com.flipkart.fdp.irm.core.facade.IResourceProfileFacade;
import com.flipkart.fdp.irm.core.facade.ResourceProfileFacade;
import com.flipkart.fdp.irm.exceptions.EBase;
import com.flipkart.fdp.irm.exceptions.ENotYetImplemented;
import com.flipkart.fdp.irm.hadoop.hdfs.db.HdfsProfile;
import com.flipkart.fdp.irm.webentities.HdfsProfileWebEntity;
import com.flipkart.fdp.irm.webentities.ResourceProfileWebEntity;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.inject.Inject;
import java.util.List;

public class CHdfsProfileFacade
extends ResourceProfileFacade<HdfsProfile>
implements IResourceProfileFacade {
    private IResourceProfileDao<HdfsProfile> hdfsProfileDao;

    @Inject
    public CHdfsProfileFacade(IResourceProfileDao<HdfsProfile> hdfsProfileDao) {
        this.hdfsProfileDao = hdfsProfileDao;
    }

    public ResourceProfileWebEntity createProfile(ResourceProfileWebEntity hdfsProfile) throws EBase {
        HdfsProfile createdHdfsProfile = (HdfsProfile)((Object)this.hdfsProfileDao.save((Object)this.toDbEntity(hdfsProfile)));
        this.toWebEntity(createdHdfsProfile);
        throw new ENotYetImplemented();
    }

    public ResourceProfileWebEntity getProfile(Long profileId) throws EBase {
        return this.toWebEntity((HdfsProfile)((Object)this.hdfsProfileDao.getById(profileId)));
    }

    public ResourceProfileWebEntity deleteProfile(Long profileId) throws EBase {
        HdfsProfile hdfsProfile = (HdfsProfile)((Object)this.hdfsProfileDao.deleteById(profileId));
        this.toWebEntity(hdfsProfile);
        throw new ENotYetImplemented();
    }

    public List<ResourceProfileWebEntity> getAllProfiles() throws EBase {
        List hdfsProfileList = this.hdfsProfileDao.getAll();
        return this.toWebEntityList(hdfsProfileList);
    }

    protected HdfsProfile toDbEntity(ResourceProfileWebEntity hdfsProfileWebEntity) {
        HdfsProfile hdfsProfile = new HdfsProfile();
        hdfsProfile.setSpaceUnit(((HdfsProfileWebEntity)hdfsProfileWebEntity).getSpaceUnit());
        hdfsProfile.setDiskSpace(((HdfsProfileWebEntity)hdfsProfileWebEntity).getDiskSpace());
        hdfsProfile.setDescription(hdfsProfileWebEntity.getDescription());
        return hdfsProfile;
    }

    protected ResourceProfileWebEntity toWebEntity(HdfsProfile hdfsProfile) {
        HdfsProfileWebEntity hdfsProfileWebEntity = new HdfsProfileWebEntity(hdfsProfile.getDescription(), hdfsProfile.getDiskSpace(), hdfsProfile.getSpaceUnit());
        hdfsProfileWebEntity.setId(hdfsProfile.getId());
        return hdfsProfileWebEntity;
    }

    protected List<ResourceProfileWebEntity> toWebEntityList(List<HdfsProfile> hdfsProfileList) {
        return FluentIterable.from(hdfsProfileList).transform((Function)new Function<HdfsProfile, ResourceProfileWebEntity>(){

            public ResourceProfileWebEntity apply(HdfsProfile input) {
                return CHdfsProfileFacade.this.toWebEntity(input);
            }
        }).toList();
    }
}

